% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_obt10_bruf.R
\name{sim_obt10_bruf}
\alias{sim_obt10_bruf}
\title{Scrapes SIM's ICD-10 data from regions}
\usage{
sim_obt10_bruf(linha = "Região", coluna = "Não ativa",
  conteudo = 1, periodo = "last", regiao = "all", unidade_da_federacao = "all",
  capitulo_cid10 = "all", grupo_cid10 = "all", categoria_cid10 = "all",
  causa_br_cid10 = "all", causa_mal_definida = "all", faixa_etaria = "all",
  faixa_etaria_ops = "all", faixa_etaria_det = "all", faixa_etaria_menor1a = "all",
  sexo = "all", cor_raca = "all", escolaridade = "all", estado_civil = "all",
  local_ocorrencia = "all")
}
\arguments{
\item{linha}{A character describing which element will be displayed in the rows of the data.frame. Defaults to "Região".}

\item{coluna}{A character describing which element will be displayed in the columns of the data.frame. Defaults to "Não ativa".}

\item{conteudo}{A character of length = 1 with the state's acronym of interest.}

\item{periodo}{A character vector describing the period of data. Defaults to the last available.}

\item{regiao}{"all" or a numeric vector with the IBGE's region codes to filter the data. Defaults to "all".}

\item{unidade_da_federacao}{"all" or a numeric vector with the IBGE's state codes to filter the data. Defaults to "all".}

\item{capitulo_cid10}{"all" or a numeric vector with the ICD-10 chapter to filter the data. Defaults to "all".}

\item{grupo_cid10}{"all" or a character vector with the ICD-10 group (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{categoria_cid10}{"all" or a character vector with the ICD-10 category codes (capital letter and two numbers) to filter the data. Defaults to "all".}

\item{causa_br_cid10}{"all" or a character vector with the ICD-10 cause codes to filter the data. Defaults to "all".}

\item{causa_mal_definida}{"all" or a character vector with the ill-defined causes (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{faixa_etaria}{"all" or a character vector with the age range (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{faixa_etaria_ops}{"all" or a character vector with the age range (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all". "ops" in the argument name stands for Pan American Health Organization.}

\item{faixa_etaria_det}{"all" or a character vector with the age range (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{faixa_etaria_menor1a}{"all" or a character vector with the age range (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{sexo}{"all" or a character vector with the gender (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{cor_raca}{"all" or a character vector with the color/race (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{escolaridade}{"all" or a character vector with the instruction (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{estado_civil}{"all" or a character vector with the marital status (written in the same way) or the number corresponding to the order of the option in the online layout to filter the data. Defaults to "all".}

\item{local_ocorrencia}{"all" or a character vector with the place of ocurrence to filter the data. Defaults to "all".}
}
\value{
The function returns a data frame printed by parameters input.
}
\description{
This function allows the user to retrieve data from
SIM's ICD-10 database much in the same way that is done
by the online portal. The argument options refer to
data focused on the regions and states.
}
\examples{
\dontrun{
## Requesting data from Midwest region
sim_obt10_bruf(region = 5)
}

}
\seealso{
\code{\link{sinasc_nv_uf}}
}
\author{
Renato Prado Siqueira \email{<rpradosiqueira@gmail.com>}
}
\keyword{SIM}
\keyword{datasus}
