% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dv.R
\name{create_dv}
\alias{create_dv}
\title{Create dv}
\usage{
create_dv(df, destination, key_cols = NA, diffed = TRUE, backup_count = 0L)
}
\arguments{
\item{df}{a data frame}

\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{key_cols}{a character vector of column names that constitute a unique key}

\item{diffed}{should we store diffs between each dv version?}

\item{backup_count}{how many backups should we store?}
}
\value{
TRUE
}
\description{
Create a versioned dataset
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])

create_dv(df, temp_dir)

unlink(temp_dir)

}
