% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deter.R
\name{load_deter}
\alias{load_deter}
\title{DETER - Forest Degradation in the Brazilian Amazon}
\usage{
load_deter(dataset, raw_data = FALSE, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("deter_amz", "deter_cerrado") with information about both Amazon and Cerrado}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Portuguese ("pt") and English ("eng") are supported.}
}
\value{
A \code{tibble} (if \code{raw_data} = \code{TRUE}) or a \code{sf} object (if \code{raw_data} = \code{FALSE}).
}
\description{
Loads information on changes in forest cover in the Amazon.
}
\examples{
\dontrun{
# Download treated data (raw_data = FALSE) from Amazonia (dataset = "deter_amz")
deter_amz <- load_deter(
  dataset = "deter_amz",
  raw_data = FALSE
)
}

}
