% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_use.R
\name{datelife_use}
\alias{datelife_use}
\title{Generate one or multiple chronograms for a set of given taxon names.}
\usage{
datelife_use(input = NULL, each = FALSE, dating_method = "bladj", ...)
}
\arguments{
\item{input}{One of the following:
\describe{
\item{A character vector}{With taxon names as a single comma separated
starting or concatenated with \code{\link[=c]{c()}}.}
\item{A phylogenetic tree with taxon names as tip labels}{As a \code{phylo} or
\code{multiPhylo} object, OR as a newick character string.}
\item{A \code{datelifeQuery} object}{An output from \code{\link[=make_datelife_query]{make_datelife_query()}}.}
}}

\item{each}{Boolean, default to \code{FALSE}: all calibrations are returned in
the same \code{data.frame}. If \code{TRUE}, calibrations from each chronogram are returned
in separate data frames.}

\item{dating_method}{Tree dating algorithm to use. Options are "bladj" or "pathd8"
(Webb et al., 2008, \doi{10.1093/bioinformatics/btn358}; Britton et al., 2007,
\doi{10.1080/10635150701613783}).}

\item{...}{
  Arguments passed on to \code{\link[=make_datelife_query]{make_datelife_query}}
  \describe{
    \item{\code{use_tnrs}}{Whether to use Open Tree of Life's Taxonomic Name Resolution Service (TNRS)
to process input taxon names. Default to \code{TRUE}, it corrects misspellings and
taxonomic name variations with \code{\link[=tnrs_match]{tnrs_match()}}, a wrapper of \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}}.}
    \item{\code{get_spp_from_taxon}}{Whether to search ages for all species belonging to a
given taxon or not. Default to \code{FALSE}. If \code{TRUE}, it must have same length as input.
If input is a newick string with some clades it will be converted to a \code{phylo}
object, and the order of \code{get_spp_from_taxon} will match \code{phy$tip.label}.}
    \item{\code{taxonomic_source}}{Used if \code{get_spp_from_taxon = TRUE}. A character vector with the desired taxonomic sources.
Options are "ott", "ncbi", "gbif" or "irmng". The function defaults to "ott".}
  }}
}
\value{
A \code{phylo} or \code{multiPhylo} object with branch lengths proportional to time.
}
\description{
\code{datelife_use} gets secondary calibrations available for any
pair of given taxon names, mined from the \link{opentree_chronograms} object,
congruifies them, and uses them to date a given tree topology with the
algorithm defined in \code{dating_method}. If no tree topology is provided,
it will attempt to get one for the given taxon names from Open Tree of Life
synthetic tree, using \code{\link[=make_bold_otol_tree]{make_bold_otol_tree()}}.
}
\details{
If \code{input} is a vector of taxon names, the function will attempt to reconstruct a BOLD
tree with \code{\link[=make_bold_otol_tree]{make_bold_otol_tree()}} to get a tree with branch lengths. If it fails,
it will get an Open Tree of Life synthetic tree topology.
The function then calls \code{\link[=use_calibrations]{use_calibrations()}}.
}
\section{More}{
 The output object stores the used \code{calibrations} and \code{dating_method} as
\code{attributes(output)$datelife_calibrations} and \code{attributes(output)$dating_method}.
}

