% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_fix_brlen.R
\name{tree_fix_brlen}
\alias{tree_fix_brlen}
\title{Take a tree with branch lengths and fix negative or zero length branches.}
\usage{
tree_fix_brlen(
  tree = NULL,
  fixing_criterion = "negative",
  fixing_method = 0,
  ultrametric = TRUE
)
}
\arguments{
\item{tree}{A tree either as a newick character string or as a \code{phylo} object.}

\item{fixing_criterion}{A character vector specifying the type of branch length to be fixed: "negative" or "zero" (the number 0 is also allowed).}

\item{fixing_method}{A character vector specifying the method to fix branch lengths: "bladj", "mrbayes" or a number to be assigned to all branches meeting fixing_criterion}

\item{ultrametric}{Boolean indicating whether to force ultrametric or not.}
}
\value{
A \code{phylo} object with no negative or zero branch lengths.
}
\description{
Take a tree with branch lengths and fix negative or zero length branches.
}
