% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference.test.R
\name{reference.test}
\alias{reference.test}
\title{Test \code{dbi.table} vs. Reference Implementation}
\usage{
reference.test(
  expr,
  envir = parent.frame(),
  ignore.row.order = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{expr}{an expression involving at least one \code{dbi.table} and whose result can
be coerced into a \code{data.table}.}

\item{envir}{an environment. Where to evaluate \code{expr}.}

\item{ignore.row.order}{a logical value. This argument is passed to \code{\link{all.equal}}.}

\item{verbose}{a logical value. When \code{TRUE}, the output from \code{all.equal} is
displayed in a message when \code{all.equal} returns anything other than
\code{TRUE}.}
}
\value{
a logical value.
}
\description{
Evaluate an expression including at least one \code{dbi.table} and compare
the result with the \emph{Reference Implementation}. This function is
primarily for testing and is potentially very slow for large tables.
}
\section{Reference Implementation}{

  Suppose that \code{id1} identifies a table in a SQL database and that
  \code{[i, j, by]} describes a subset/select/summarize operation using
  \code{data.table} syntax. The \emph{Reference Implementation} for this
  operation is:

  \code{setDT(dbReadTable(conn, id1))[i, j, by]}

  More generally, for an expression involving multiple SQL database objects
  and using \code{data.table} syntax, the \emph{Reference Implementation}
  would be to download each of these objects in their entirety, convert them
  to \code{data.table}s, then evaluate the expression.

  The goal of the \pkg{dbi.table} is to generate an SQL query that produces
  the same results set as the Reference Implementation up to row ordering.
}

\examples{
  duck <- dbi.catalog(chinook.duckdb)
  Album <- duck$main$Album
  Artist <- duck$main$Artist

  reference.test(merge(Album, Artist, by = "ArtistId"))

}
