% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvn_exact_inference.R
\name{mvn_inference}
\alias{mvn_inference}
\title{Performs inference over a multivariate normal distribution}
\usage{
mvn_inference(mu, sigma, evidence)
}
\arguments{
\item{mu}{the mean vector}

\item{sigma}{the covariance matrix}

\item{evidence}{a single row data.table or a named vector with the values and names of the variables given as evidence}
}
\value{
a list with the posterior mean and covariance matrix
}
\description{
Given some evidence, this function performs inference over a multivariate normal 
distribution. After converting a Gaussian linear network to its MVN form, this
kind of inference can be performed. It's recommended to use
\code{\link{predict_dt}} functions instead unless you need a more flexible 
inference method.
}
\examples{
size = 3
data(motor)
dt_train <- motor[200:2500]
dt_val <- motor[2501:3000]
obj <- c("pm_t_0")

net <- learn_dbn_struc(dt_train, size)
f_dt_train <- fold_dt(dt_train, size)
f_dt_val <- fold_dt(dt_val, size)
ev <- f_dt_val[1, .SD, .SDcols = obj]
fit <- fit_dbn_params(net, f_dt_train, method = "mle-g")

pred <- mvn_inference(calc_mu(fit), calc_sigma(fit), ev)
}
