% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/template_matching.R
\name{shift3D}
\alias{shift3D}
\title{Shift a 3D Array in One Dimension}
\usage{
shift3D(A, s, type, fill = 0)
}
\arguments{
\item{A}{is a three-dimensional array.}

\item{s}{is the integer number of translation steps.}

\item{type}{is a character string using anatomical coordinates assuming a
transverse acquisition scheme (\dQuote{LR} = left-right = x-axis,
\dQuote{AP} = anterior-posterior = y-axis, \dQuote{SI} = superior-inferior =
z-axis).}

\item{fill}{is the quantity used to fill gaps induced by the translations
(circular boundary conditions are NOT used).}
}
\value{
A three-dimensional array is returned, the same dimension as the
original array, with one dimension translated.
}
\description{
One axis of the three-dimensional array is translated by an integer amount.
This is useful when applying convolution operators in the Fourier domain.
}
\examples{
cube <- array(0, rep(20,3))
cube[9:12,9:12,9:12] <- 1
cube.shift <- shift3D(cube, 5, type="AP")
par(mfrow=c(1,2), mar=rep(0.5,4))
image(cube[,,10], xlab="", ylab="", axes=FALSE)
image(cube.shift[,,10], xlab="", ylab="", axes=FALSE)
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\seealso{
\code{\link{convFFT}}
}

