% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-wildtype_mutant_pnpp.R
\name{wildtype_mutant_pnpp}
\alias{wildtype_mutant_pnpp}
\title{Plate type: wildtype/mutant PNPP}
\description{
A plate of type \code{wildtype_mutant_pnpp} is a subtype of
\code{\link[ddpcr]{pnpp_experiment}} that assumes the double-positive cluster
denotes wildtype and the other non-empty cluster denotes mutant droplets.
There are two plate types that are subtypes of \code{wildtype_mutant_pnpp}:
\code{\link[ddpcr]{fam_positive_pnpp}} and \code{\link[ddpcr]{hex_positive_pnpp}}.
It is not recommended to use this type directly; instead you should use one
of the subtypes.
}
\details{
Plates with this type have the following analysis steps: \code{INITIALIZE},
\code{REMOVE_FAILURES}, \code{REMOVE_OUTLIERS}, \code{REMOVE_EMPTY},
\code{CLASSIFY}, \code{RECLASSIFY}.

Plates with this type have the following droplet clusters:
\code{UNDEFINED}, \code{FAILED}, \code{OUTLIER}, \code{EMPTY} (double-negative),
\code{RAIN} (not empty but not wildtype nor negative), \code{POSITIVE} (wildtype),
\code{NEGATIVE} (mutant).

\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for
more information on plate types.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$wildtype_mutant_pnpp)
type(plate)
} 
}
\seealso{
\code{\link[ddpcr]{plate_types}}\cr
\code{\link[ddpcr]{fam_positive_pnpp}}\cr
\code{\link[ddpcr]{hex_positive_pnpp}}\cr
\code{\link[ddpcr]{pnpp_experiment}}\cr
\code{\link[ddpcr]{analyze}}\cr
\code{\link[ddpcr]{remove_failures}}\cr
\code{\link[ddpcr]{remove_outliers}}\cr
\code{\link[ddpcr]{remove_empty}}\cr
\code{\link[ddpcr]{classify_droplets}}\cr
\code{\link[ddpcr]{reclassify_droplets}}
}

