% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{named_vec_to_df}
\alias{named_vec_to_df}
\title{Convert a named vector returned from vapply to a dataframe}
\usage{
named_vec_to_df(v, name, rowname = "well")
}
\arguments{
\item{v}{Named vector that is a result of a vapply}

\item{name}{Column name to use for the name of each element}

\item{rowname}{Column name to use for the values of the rownames}
}
\description{
When running a \code{vapply} function and each element returns a single value,
the return value is a named vector.  This function can be used to convert
that return value into a data.frame. Similar to \code{\link[ddpcr]{lol_to_df}},
but because the output format from \code{vapply} is different depending on
whether a single value or multiple values are returned, a different function
needs to be used.
}
\examples{
vapply(c("a", "b", "c"),
       toupper,
       character(1)) \%>\%
  named_vec_to_df("capital", "letter")
}
\seealso{
\code{\link[ddpcr]{lol_to_df}}
}
\keyword{internal}

