% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_basic.R
\name{bootstrap_basic}
\alias{bootstrap_basic}
\title{Bootstrapping DEA}
\usage{
bootstrap_basic(datadea,
                orientation = c("io", "oo"),
                rts = c("crs", "vrs", "nirs", "ndrs", "grs"),
                L = 1,
                U = 1,
                B = 2000,
                h = NULL,
                alpha = 0.05)
}
\arguments{
\item{datadea}{The data, including \code{n} DMUs, \code{m} inputs and \code{s} outputs.}

\item{orientation}{A string, equal to "io" (input oriented) or "oo" (output oriented).}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing), "ndrs" (non-decreasing) or "grs" (generalized).}

\item{L}{Lower bound for the generalized returns to scale (grs).}

\item{U}{Upper bound for the generalized returns to scale (grs).}

\item{B}{Number of bootstrap iterations.}

\item{h}{Bandwith or smoothing window. By default h=0.014 (You can set h to any other value). The optimal bandwidth factor can also be calculated following the proposals of Silverman (1986) and Dario y Simar (2007). So, h="h1" is the optimal h referred as "robust normal-reference rule" (Dario and Simar, 2007 p.60), h="h2" is the value of h1 but instead of the factor 1.06 with the factor 0.9, h="h3" is the value of h1 adjusted for scale and sample size (Dario and Simar, 2007 p.61), and h="h4" is the bandwith provided by a Gaussian kernel destiy estimate.}

\item{alpha}{Between 0 and 1 (for confidence intervals).}
}
\description{
To bootstrap efficiency scores, deaR uses the algorithm proposed by Simar and Wilson (1998). For now, the function bootstrap_basic can only be used with basic DEA models (input- and output-oriented under constant and variable returns-to-scale).
}
\examples{
# To replicate the results in Simar y Wilson (1998, p. 58) you have to
# set B=2000 (in the example B = 100 to save time)
data("Electric_plants")
data_example <- read_data(Electric_plants, 
                          ni = 3, 
                          no = 1)
result <- bootstrap_basic(datadea = data_example,
                             orientation = "io",
                             rts = "vrs",
                             B = 100)
result$score_bc
result$CI

}
\references{
Behr, A. (2015). Production and Efficiency Analysis with R. Springer.

Bogetoft, P.; Otto, L. (2010).  Benchmarking with DEA, SFA, and R. Springer.

Daraio, C.; Simar, L. (2007). Advanced Robust and Nonparametric Methods in Efficiency Analysis: Methodology and Applications. New York: Springer.

Färe, R.; Grosskopf, S.; Kokkenlenberg, E. (1989). "Measuring Plant Capacity, Utilization and Technical Change: A Nonparametric Approach". International Economic Review, 30(3), 655-666. 

Löthgren, M.; Tambour, M. (1999). "Bootstrapping the Data Envelopment Analysis Malmquist Productivity Index". Applied Economics, 31, 417-425. 

Silverman, B.W. (1986). Density Estimation for Statistics and Data Analysis. London: Chapman and Hall. 

Simar, L.; Wilson, P.W. (1998). "Sensitivity Analysis of Efficiency Scores: How to Bootstrap in Nonparametric Frontier Models". Management Science, 44(1), 49-61. 

Simar, L.; Wilson, P.W. (1999). "Estimating and Bootstrapping Malmquist Indices". European Journal of Operational Research, 115, 459-471. 

Simar, L.; Wilson, P.W. (2008). Statistical Inference in Nonparametric Frontier Models: Recent Developments and Perspective. In H.O. Fried; C.A. Knox Lovell and S.S. Schmidt (eds.) The Measurement of Productive Efficiency and Productivity Growth. New York: Oxford University Press. DOI:10.1093/acprof:oso/9780195183528.001.0001
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
