% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_icon-layer.R
\name{add_icon_layer}
\alias{add_icon_layer}
\title{Add an icon layer to the deckgl widget}
\usage{
add_icon_layer(deckgl, id = "icon-layer", data = NULL,
  properties = use_default_icon_properties(), ...)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{id}{The unique id of the layer.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class.}

\item{...}{More properties that will be added to the \code{properties} object. This can be useful
if you want to use a properties object for more than one layer.}
}
\description{
The \code{IconLayer} renders raster icons at given coordinates.
}
\examples{
## @knitr icon-layer
data("bart_stations")

properties <- list(
  iconAtlas = encode_icon_atlas(),
  iconMapping = list(marker = use_icon_definition()),
  sizeScale = 10,
  getPosition = ~lng + lat,
  getIcon = JS("d => 'marker'"),
  getSize = 5,
  getColor = JS("d => [Math.sqrt(d.exits), 140, 0]"),
  getTooltip = "{{name}}<br/>{{address}}"
)

deck <- deckgl(zoom = 10, pitch = 45) \%>\%
  add_icon_layer(data = bart_stations, properties = properties) \%>\%
  add_control("Icon Layer") \%>\%
  add_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/icon-layer}
}
