% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepboost-grid-search.R
\name{deepboost.gridSearch}
\alias{deepboost.gridSearch}
\title{Returns optimised parameter list for deepboost model on given data}
\usage{
deepboost.gridSearch(formula, data, k = 10, seed = 666, logging_level = 1)
}
\arguments{
\item{formula}{A R Formula object see : ?formula}

\item{data}{input data.frame as training for model}

\item{k}{number of folds (default = 10) for cross validation optimisation}

\item{seed}{for random split to train / test (default 666)}

\item{logging_level}{print extra data while training 0 - no data, 1 - gridSearch data (default), 2 - all data}
}
\value{
vector with average accuracy for chosen parameters, and a list of the best parameter combination: (accuracy, (num_iter, beta, lambda, loss_type))
}
\description{
Returns optimised parameter list for deepboost model on given data
}
\details{
Finds optimised parameters for deepboost training.
 using grid search techniques over:
 - predefined, battle tested parameter possible values
 - cross validation over k folds
}
\examples{
deepboost.gridSearch(y ~ .,
 data.frame(x1=rep(c(0,0,1,1),2),x2=rep(c(0,1,0,1),2),y=factor(rep(c(0,0,0,1),2))), k=2)
}

