/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.dto.MassSpectrometryMeasurement;
import ch.fgcz.proteomics.dto.MassSpectrum;
import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.IsotopicCluster;
import ch.fgcz.proteomics.fbdm.IsotopicSet;
import ch.fgcz.proteomics.fbdm.Peak;
import ch.fgcz.proteomics.fbdm.PeakList;
import java.util.ArrayList;
import java.util.List;

public class Deisotoper {
    private boolean running = false;
    private PeakList peakList;
    private PeakList mergedPeakList;
    private Configuration config;
    private List<IsotopicSet> isotopicSets = new ArrayList<IsotopicSet>();

    public void wasRunning() throws Exception {
        if (!this.running) {
            throw new Exception("You must run the deisotope method before you can get a annotated spectrum/dot graphs/summary");
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public String getAnnotatedSpectrum() {
        return this.mergedPeakList.saveAnnotatedSpectrum();
    }

    public List<String> getDotGraphs() {
        ArrayList<String> graph = new ArrayList<String>();
        for (IsotopicSet isotopicSet : this.isotopicSets) {
            graph.add(isotopicSet.getDot());
        }
        return graph;
    }

    public List<IsotopicSet> getIsotopicSets() {
        return this.isotopicSets;
    }

    public MassSpectrometryMeasurement deisotopeMSM(MassSpectrometryMeasurement massSpectrometryMeasurementin, Configuration config) {
        MassSpectrometryMeasurement massSpectrometryMeasurementOut = new MassSpectrometryMeasurement(massSpectrometryMeasurementin.getSource());
        this.config = config;
        for (MassSpectrum massSpectrum : massSpectrometryMeasurementin.getMSlist()) {
            massSpectrometryMeasurementOut.getMSlist().add(this.deisotopeMS(massSpectrum));
        }
        return massSpectrometryMeasurementOut;
    }

    public MassSpectrum deisotopeMS(MassSpectrum massSpectrum) {
        this.running = true;
        this.isotopicSets = new ArrayList<IsotopicSet>();
        this.generateIsotopicSets(massSpectrum);
        List<IsotopicCluster> bestClusters = this.getBestClusters();
        PeakList peakListAggregated = this.aggregate(bestClusters, this.config.getModus());
        if (this.config.isDecharge()) {
            peakListAggregated = peakListAggregated.dechargePeaks(this.config.getH_MASS());
        }
        this.mergedPeakList = this.peakList.mergePeakLists(peakListAggregated);
        if (this.config.getNoise() != 0.0) {
            this.mergedPeakList = this.mergedPeakList.filterNoisePeaks(this.config.getNoise());
        }
        this.mergedPeakList = this.mergedPeakList.sortPeakList();
        return this.mergedPeakList.makeResultSpectrum(massSpectrum);
    }

    private List<IsotopicCluster> getBestClusters() {
        ArrayList<IsotopicCluster> bestClusters = new ArrayList<IsotopicCluster>();
        for (IsotopicSet isotopicSet : this.isotopicSets) {
            bestClusters.addAll(isotopicSet.getBestPath());
        }
        return bestClusters;
    }

    private PeakList aggregate(List<IsotopicCluster> isotopicClusters, String modus) {
        PeakList resultPeakList = new PeakList();
        for (IsotopicCluster istotopicCluster : isotopicClusters) {
            IsotopicCluster aggregatedCluster = istotopicCluster.aggregation(modus);
            Peak peak = aggregatedCluster.getPeak(0);
            resultPeakList.add(peak);
        }
        return resultPeakList;
    }

    private void generateIsotopicSets(MassSpectrum massSpectrum) {
        this.peakList = new PeakList(massSpectrum);
        int id = 0;
        for (int i = 0; i < this.peakList.size(); ++i) {
            ArrayList<Peak> isotopicSet = new ArrayList<Peak>();
            while (i < this.peakList.size() - 1) {
                boolean trigger = false;
                double distance = this.peakList.get(i + 1).getMz() - this.peakList.get(i).getMz();
                for (int charge = 1; charge <= 3; ++charge) {
                    Peak peak;
                    if (!(this.config.getDistance() / (double)charge - this.config.getDelta() < distance) || !(distance < this.config.getDistance() / (double)charge + this.config.getDelta())) continue;
                    if (isotopicSet.size() == 0) {
                        peak = this.peakList.get(i);
                        peak.setInSet(true);
                        isotopicSet.add(peak);
                    }
                    peak = this.peakList.get(i + 1);
                    peak.setInSet(true);
                    isotopicSet.add(peak);
                    trigger = true;
                }
                if (!trigger) break;
                ++i;
            }
            if (1 >= isotopicSet.size()) continue;
            IsotopicSet temporaryIsotopicSet = new IsotopicSet(massSpectrum, isotopicSet, id, this.config);
            ++id;
            this.isotopicSets.add(temporaryIsotopicSet);
            if (isotopicSet.size() == this.peakList.size()) break;
        }
    }
}

