/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.mspy;

import ch.fgcz.proteomics.mspy.Peak;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

@Deprecated
public class Mspy {
    public static final double ISOTOPE_DISTANCE = 1.00287;
    public static final double ELECTRON_MASS = 5.4857990924E-4;
    public static final double H_MASS = 1.008;

    public static List<Peak> deisotope(List<Peak> peaklist, int maxcharge, double mztolerance, double inttolerance, double isotopeshift) {
        int i;
        ArrayList<Integer> charges = new ArrayList<Integer>();
        for (Peak p : peaklist) {
            p.setCharge(-1);
            p.setIsotope(-1.0);
        }
        if (maxcharge < 0) {
            for (i = 1; i <= Math.abs(maxcharge) + 1; ++i) {
                charges.add(-i);
            }
        } else {
            for (i = 1; i <= maxcharge + 1; ++i) {
                charges.add(i);
            }
        }
        Collections.reverse(charges);
        int maxindex = peaklist.size();
        int x = 0;
        for (Peak parent : peaklist) {
            if (parent.getIsotope() != -1.0) continue;
            Iterator iterator = charges.iterator();
            while (iterator.hasNext()) {
                int z = (Integer)iterator.next();
                ArrayList<Peak> cluster = new ArrayList<Peak>();
                cluster.add(parent);
                double difference = (1.00287 + isotopeshift) / (double)Math.abs(z);
                int y = 1;
                while (x + y < maxindex) {
                    double mzerror = peaklist.get(x + y).getMz() - ((Peak)cluster.get(cluster.size() - 1)).getMz() - difference;
                    if (Math.abs(mzerror) <= mztolerance) {
                        cluster.add(peaklist.get(x + y));
                    } else if (mzerror > mztolerance) break;
                    ++y;
                }
                if (cluster.size() == 1) continue;
                int mass = Math.min(15000, (int)Mspy.calculateMass(parent.getMz(), 0, z, 0)) / 200;
                List<Double> pattern = Mspy.initPattern(mass);
                int lim = 0;
                for (double p : pattern) {
                    if (!(p >= 0.33)) continue;
                    ++lim;
                }
                if (cluster.size() < lim && Math.abs(z) > 1) continue;
                boolean valid = true;
                int limit = Math.min(pattern.size(), cluster.size());
                for (int isotope = 1; isotope < limit; ++isotope) {
                    double inttheoretical = ((Peak)cluster.get(isotope - 1)).getIntensity() / pattern.get(isotope - 1) * pattern.get(isotope);
                    double interror = ((Peak)cluster.get(isotope)).getIntensity() - inttheoretical;
                    if (Math.abs(interror) <= inttheoretical * inttolerance) {
                        ((Peak)cluster.get(isotope)).setIsotope(isotope);
                        ((Peak)cluster.get(isotope)).setCharge(z);
                        continue;
                    }
                    if (interror < 0.0 && isotope == 1) {
                        valid = false;
                        break;
                    }
                    if (!(interror > 0.0)) continue;
                }
                if (!valid || z >= 4) continue;
                parent.setIsotope(0.0);
                parent.setCharge(z);
                break;
            }
            ++x;
        }
        List<Peak> list = Mspy.removeEmptyPeaks(peaklist);
        list = Mspy.sortPeaklist(list);
        return list;
    }

    private static double calculateMass(double mass, int charge, int currentcharge, int masstype) {
        int agentcharge = 1;
        double agentmass = 1.008;
        double agentcount = currentcharge / agentcharge;
        agentmass -= (double)agentcharge * 5.4857990924E-4;
        if (currentcharge != 0) {
            mass = mass * (double)Math.abs(currentcharge) - agentmass * agentcount;
        }
        if (charge == 0) {
            return mass;
        }
        double agentcount2 = charge / agentcharge;
        return (mass + agentmass * agentcount2) / (double)Math.abs(charge);
    }

    public static List<Peak> removeEmptyPeaks(List<Peak> peaklist) {
        ArrayList<Peak> peaklistout = new ArrayList<Peak>();
        for (int i = 0; i < peaklist.size(); ++i) {
            if (peaklist.get(i).getIsotope() == -1.0 || peaklist.get(i).getCharge() == -1) continue;
            peaklistout.add(peaklist.get(i));
        }
        return peaklistout;
    }

    private static List<Double> initPattern(int mass) {
        ArrayList<List<Double>> patternLookupTable = new ArrayList<List<Double>>();
        patternLookupTable.add(Arrays.asList(1.0, 0.059, 0.003));
        patternLookupTable.add(Arrays.asList(1.0, 0.122, 0.013));
        patternLookupTable.add(Arrays.asList(1.0, 0.241, 0.04, 0.005));
        patternLookupTable.add(Arrays.asList(1.0, 0.303, 0.059, 0.008));
        patternLookupTable.add(Arrays.asList(1.0, 0.426, 0.109, 0.02, 0.003));
        patternLookupTable.add(Arrays.asList(1.0, 0.533, 0.166, 0.038, 0.006));
        patternLookupTable.add(Arrays.asList(1.0, 0.655, 0.244, 0.066, 0.014, 0.002));
        patternLookupTable.add(Arrays.asList(1.0, 0.786, 0.388, 0.143, 0.042, 0.009, 0.001));
        patternLookupTable.add(Arrays.asList(1.0, 0.845, 0.441, 0.171, 0.053, 0.013, 0.002));
        patternLookupTable.add(Arrays.asList(1.0, 0.967, 0.557, 0.236, 0.08, 0.021, 0.005));
        patternLookupTable.add(Arrays.asList(0.921, 1.0, 0.63, 0.291, 0.107, 0.032, 0.007, 0.001));
        patternLookupTable.add(Arrays.asList(0.828, 1.0, 0.687, 0.343, 0.136, 0.044, 0.011, 0.002));
        patternLookupTable.add(Arrays.asList(0.752, 1.0, 0.744, 0.4, 0.171, 0.06, 0.017, 0.004));
        patternLookupTable.add(Arrays.asList(0.72, 1.0, 0.772, 0.428, 0.188, 0.068, 0.02, 0.005));
        patternLookupTable.add(Arrays.asList(0.667, 1.0, 0.825, 0.487, 0.228, 0.088, 0.028, 0.007));
        patternLookupTable.add(Arrays.asList(0.616, 1.0, 0.884, 0.556, 0.276, 0.113, 0.039, 0.01, 0.002));
        patternLookupTable.add(Arrays.asList(0.574, 1.0, 0.941, 0.628, 0.33, 0.143, 0.052, 0.015, 0.003));
        patternLookupTable.add(Arrays.asList(0.536, 0.999, 1.0, 0.706, 0.392, 0.179, 0.069, 0.022, 0.005));
        patternLookupTable.add(Arrays.asList(0.506, 0.972, 1.0, 0.725, 0.412, 0.193, 0.077, 0.025, 0.006));
        patternLookupTable.add(Arrays.asList(0.449, 0.919, 1.0, 0.764, 0.457, 0.226, 0.094, 0.033, 0.009, 0.001));
        patternLookupTable.add(Arrays.asList(0.392, 0.853, 1.0, 0.831, 0.543, 0.295, 0.136, 0.053, 0.017, 0.004));
        patternLookupTable.add(Arrays.asList(0.353, 0.812, 1.0, 0.869, 0.593, 0.336, 0.162, 0.067, 0.023, 0.006));
        patternLookupTable.add(Arrays.asList(0.321, 0.776, 1.0, 0.907, 0.644, 0.379, 0.19, 0.082, 0.03, 0.009));
        patternLookupTable.add(Arrays.asList(0.308, 0.76, 1.0, 0.924, 0.669, 0.401, 0.205, 0.09, 0.033, 0.011, 0.001));
        patternLookupTable.add(Arrays.asList(0.282, 0.729, 1.0, 0.962, 0.723, 0.451, 0.239, 0.11, 0.042, 0.014, 0.003));
        patternLookupTable.add(Arrays.asList(0.258, 0.699, 1.0, 1.0, 0.78, 0.504, 0.277, 0.132, 0.053, 0.018, 0.004));
        patternLookupTable.add(Arrays.asList(0.228, 0.645, 0.962, 1.0, 0.809, 0.542, 0.308, 0.153, 0.065, 0.023, 0.007));
        patternLookupTable.add(Arrays.asList(0.203, 0.598, 0.927, 1.0, 0.839, 0.581, 0.343, 0.176, 0.078, 0.029, 0.01));
        patternLookupTable.add(Arrays.asList(0.192, 0.577, 0.911, 1.0, 0.854, 0.602, 0.361, 0.189, 0.086, 0.033, 0.011));
        patternLookupTable.add(Arrays.asList(0.171, 0.536, 0.88, 1.0, 0.884, 0.644, 0.399, 0.216, 0.102, 0.04, 0.014, 0.003));
        patternLookupTable.add(Arrays.asList(0.154, 0.501, 0.851, 1.0, 0.912, 0.686, 0.439, 0.244, 0.12, 0.05, 0.018, 0.004));
        patternLookupTable.add(Arrays.asList(0.139, 0.468, 0.823, 1.0, 0.942, 0.73, 0.482, 0.278, 0.141, 0.062, 0.023, 0.007));
        patternLookupTable.add(Arrays.asList(0.126, 0.441, 0.799, 1.0, 0.969, 0.772, 0.524, 0.31, 0.162, 0.073, 0.028, 0.009));
        patternLookupTable.add(Arrays.asList(0.121, 0.427, 0.787, 1.0, 0.983, 0.794, 0.547, 0.328, 0.174, 0.08, 0.031, 0.011));
        patternLookupTable.add(Arrays.asList(0.104, 0.381, 0.732, 0.971, 1.0, 0.848, 0.614, 0.39, 0.219, 0.109, 0.045, 0.016, 0.004));
        patternLookupTable.add(Arrays.asList(0.092, 0.349, 0.691, 0.944, 1.0, 0.872, 0.648, 0.422, 0.244, 0.125, 0.054, 0.02, 0.006));
        patternLookupTable.add(Arrays.asList(0.082, 0.321, 0.654, 0.919, 1.0, 0.894, 0.682, 0.456, 0.27, 0.143, 0.063, 0.024, 0.008));
        patternLookupTable.add(Arrays.asList(0.073, 0.296, 0.62, 0.895, 1.0, 0.917, 0.718, 0.492, 0.299, 0.162, 0.077, 0.03, 0.011));
        patternLookupTable.add(Arrays.asList(0.069, 0.284, 0.604, 0.884, 1.0, 0.929, 0.735, 0.509, 0.313, 0.172, 0.084, 0.033, 0.012));
        patternLookupTable.add(Arrays.asList(0.062, 0.262, 0.573, 0.861, 1.0, 0.952, 0.772, 0.548, 0.345, 0.195, 0.098, 0.04, 0.015, 0.003));
        patternLookupTable.add(Arrays.asList(0.056, 0.243, 0.544, 0.839, 1.0, 0.976, 0.811, 0.589, 0.38, 0.22, 0.114, 0.049, 0.019, 0.005));
        patternLookupTable.add(Arrays.asList(0.051, 0.227, 0.521, 0.821, 1.0, 0.997, 0.846, 0.628, 0.413, 0.244, 0.13, 0.058, 0.022, 0.007));
        patternLookupTable.add(Arrays.asList(0.045, 0.206, 0.486, 0.786, 0.98, 1.0, 0.869, 0.66, 0.444, 0.268, 0.147, 0.07, 0.027, 0.01));
        patternLookupTable.add(Arrays.asList(0.042, 0.196, 0.468, 0.767, 0.968, 1.0, 0.879, 0.676, 0.46, 0.281, 0.156, 0.075, 0.03, 0.011));
        patternLookupTable.add(Arrays.asList(0.038, 0.179, 0.437, 0.733, 0.947, 1.0, 0.899, 0.705, 0.491, 0.307, 0.173, 0.086, 0.036, 0.013, 0.002));
        patternLookupTable.add(Arrays.asList(0.033, 0.163, 0.408, 0.701, 0.926, 1.0, 0.919, 0.736, 0.524, 0.335, 0.193, 0.099, 0.043, 0.016, 0.004));
        patternLookupTable.add(Arrays.asList(0.03, 0.149, 0.382, 0.67, 0.906, 1.0, 0.938, 0.768, 0.558, 0.364, 0.215, 0.113, 0.051, 0.02, 0.006));
        patternLookupTable.add(Arrays.asList(0.026, 0.132, 0.348, 0.629, 0.877, 1.0, 0.971, 0.823, 0.62, 0.42, 0.258, 0.143, 0.069, 0.028, 0.01));
        patternLookupTable.add(Arrays.asList(0.024, 0.126, 0.337, 0.616, 0.868, 1.0, 0.981, 0.839, 0.638, 0.437, 0.271, 0.153, 0.074, 0.031, 0.011));
        patternLookupTable.add(Arrays.asList(0.022, 0.116, 0.317, 0.592, 0.851, 1.0, 1.0, 0.872, 0.676, 0.472, 0.298, 0.172, 0.087, 0.037, 0.014, 0.002));
        patternLookupTable.add(Arrays.asList(0.02, 0.106, 0.294, 0.561, 0.822, 0.983, 1.0, 0.888, 0.7, 0.498, 0.32, 0.188, 0.099, 0.043, 0.017, 0.004));
        patternLookupTable.add(Arrays.asList(0.017, 0.096, 0.272, 0.529, 0.79, 0.965, 1.0, 0.905, 0.727, 0.526, 0.346, 0.207, 0.113, 0.05, 0.02, 0.006));
        patternLookupTable.add(Arrays.asList(0.015, 0.087, 0.251, 0.499, 0.761, 0.946, 1.0, 0.922, 0.755, 0.556, 0.373, 0.227, 0.126, 0.061, 0.024, 0.008));
        patternLookupTable.add(Arrays.asList(0.014, 0.083, 0.242, 0.486, 0.747, 0.937, 1.0, 0.93, 0.768, 0.57, 0.385, 0.237, 0.134, 0.065, 0.026, 0.009));
        patternLookupTable.add(Arrays.asList(0.013, 0.075, 0.225, 0.459, 0.72, 0.92, 1.0, 0.947, 0.796, 0.602, 0.415, 0.26, 0.149, 0.075, 0.032, 0.012, 0.001));
        patternLookupTable.add(Arrays.asList(0.012, 0.069, 0.208, 0.435, 0.695, 0.904, 1.0, 0.963, 0.824, 0.633, 0.443, 0.284, 0.165, 0.085, 0.037, 0.015, 0.002));
        patternLookupTable.add(Arrays.asList(0.01, 0.063, 0.194, 0.412, 0.669, 0.888, 1.0, 0.98, 0.852, 0.667, 0.475, 0.309, 0.184, 0.098, 0.044, 0.018, 0.005));
        patternLookupTable.add(Arrays.asList(0.009, 0.057, 0.18, 0.391, 0.646, 0.872, 1.0, 0.997, 0.882, 0.702, 0.509, 0.336, 0.204, 0.113, 0.052, 0.021, 0.006));
        patternLookupTable.add(Arrays.asList(0.009, 0.054, 0.173, 0.379, 0.631, 0.861, 0.995, 1.0, 0.892, 0.717, 0.523, 0.35, 0.214, 0.119, 0.057, 0.023, 0.008));
        patternLookupTable.add(Arrays.asList(0.008, 0.049, 0.16, 0.355, 0.602, 0.834, 0.98, 1.0, 0.906, 0.739, 0.548, 0.373, 0.231, 0.132, 0.066, 0.026, 0.01));
        patternLookupTable.add(Arrays.asList(0.007, 0.042, 0.141, 0.321, 0.557, 0.791, 0.953, 1.0, 0.931, 0.781, 0.596, 0.417, 0.268, 0.158, 0.082, 0.037, 0.014, 0.002));
        patternLookupTable.add(Arrays.asList(0.006, 0.038, 0.13, 0.301, 0.531, 0.767, 0.939, 1.0, 0.945, 0.805, 0.624, 0.443, 0.289, 0.174, 0.093, 0.043, 0.017, 0.004));
        patternLookupTable.add(Arrays.asList(0.005, 0.035, 0.12, 0.283, 0.507, 0.744, 0.925, 1.0, 0.96, 0.83, 0.653, 0.47, 0.312, 0.191, 0.106, 0.051, 0.02, 0.006));
        patternLookupTable.add(Arrays.asList(0.005, 0.033, 0.115, 0.274, 0.495, 0.732, 0.918, 1.0, 0.967, 0.842, 0.668, 0.485, 0.324, 0.2, 0.112, 0.054, 0.023, 0.007));
        patternLookupTable.add(Arrays.asList(0.004, 0.03, 0.107, 0.257, 0.472, 0.71, 0.904, 1.0, 0.982, 0.868, 0.699, 0.515, 0.351, 0.219, 0.126, 0.063, 0.027, 0.01));
        patternLookupTable.add(Arrays.asList(0.004, 0.027, 0.098, 0.242, 0.45, 0.689, 0.89, 1.0, 0.997, 0.894, 0.731, 0.547, 0.378, 0.241, 0.141, 0.072, 0.032, 0.012, 0.002));
        patternLookupTable.add(Arrays.asList(0.003, 0.025, 0.09, 0.224, 0.426, 0.661, 0.867, 0.989, 1.0, 0.911, 0.756, 0.574, 0.402, 0.26, 0.155, 0.082, 0.037, 0.014, 0.003));
        patternLookupTable.add(Arrays.asList(0.003, 0.022, 0.082, 0.208, 0.402, 0.633, 0.843, 0.975, 1.0, 0.925, 0.777, 0.598, 0.425, 0.279, 0.169, 0.092, 0.043, 0.017, 0.005));
        patternLookupTable.add(Arrays.asList(0.003, 0.021, 0.079, 0.202, 0.392, 0.621, 0.833, 0.969, 1.0, 0.93, 0.786, 0.609, 0.435, 0.288, 0.176, 0.097, 0.046, 0.018, 0.006));
        patternLookupTable.add(Arrays.asList(0.003, 0.019, 0.073, 0.188, 0.37, 0.595, 0.81, 0.955, 1.0, 0.943, 0.808, 0.634, 0.46, 0.309, 0.191, 0.108, 0.053, 0.022, 0.007));
        patternLookupTable.add(Arrays.asList(0.002, 0.017, 0.067, 0.175, 0.35, 0.57, 0.787, 0.942, 1.0, 0.956, 0.831, 0.662, 0.487, 0.331, 0.209, 0.121, 0.062, 0.026, 0.01));
        patternLookupTable.add(Arrays.asList(0.002, 0.016, 0.061, 0.163, 0.33, 0.547, 0.765, 0.929, 1.0, 0.968, 0.855, 0.69, 0.515, 0.356, 0.227, 0.135, 0.07, 0.031, 0.012, 0.002));
        patternLookupTable.add(Arrays.asList(0.002, 0.014, 0.056, 0.151, 0.312, 0.524, 0.743, 0.916, 1.0, 0.982, 0.878, 0.718, 0.544, 0.382, 0.247, 0.149, 0.079, 0.037, 0.014, 0.003));
        patternLookupTable.add(Arrays.asList(0.002, 0.013, 0.054, 0.146, 0.304, 0.514, 0.733, 0.909, 1.0, 0.989, 0.89, 0.733, 0.559, 0.395, 0.257, 0.156, 0.084, 0.039, 0.016, 0.004));
        patternLookupTable.add(Arrays.asList(0.001, 0.012, 0.047, 0.131, 0.276, 0.478, 0.697, 0.881, 0.989, 1.0, 0.92, 0.777, 0.605, 0.437, 0.292, 0.182, 0.102, 0.051, 0.022, 0.007));
        patternLookupTable.add(Arrays.asList(0.001, 0.01, 0.043, 0.121, 0.259, 0.454, 0.671, 0.859, 0.977, 1.0, 0.932, 0.797, 0.629, 0.46, 0.312, 0.197, 0.114, 0.058, 0.025, 0.008, 0.001));
        return (List)patternLookupTable.get(mass);
    }

    public static List<Peak> deconvolute(List<Peak> peaklist, int masstype) {
        ArrayList<Peak> buff = new ArrayList<Peak>();
        ArrayList<Peak> peaklistcopy = new ArrayList<Peak>();
        for (Peak e : peaklist) {
            peaklistcopy.add(e);
        }
        for (Peak peak : peaklistcopy) {
            if (peak.getCharge() == -1) continue;
            if (peak.getCharge() == 1) {
                buff.add(peak);
                continue;
            }
            if (peak.getFwhm() != -1.0) {
                peak.setFwhm(Math.abs(peak.getFwhm() * (double)peak.getCharge()));
            }
            if (peak.getCharge() < 0) {
                peak.setMz(Mspy.calculateMass(peak.getMz(), -1, peak.getCharge(), masstype));
                peak.setCharge(-1);
            } else {
                peak.setMz(Mspy.calculateMass(peak.getMz(), 1, peak.getCharge(), masstype));
                peak.setCharge(1);
            }
            buff.add(peak);
        }
        peaklist = buff;
        peaklist = Mspy.sortPeaklist(peaklist);
        return peaklist;
    }

    private static List<Peak> sortPeaklist(List<Peak> list) {
        Collections.sort(list, new Comparator<Peak>(){

            @Override
            public int compare(Peak o1, Peak o2) {
                Double mz1 = o1.getMz();
                Double mz2 = o2.getMz();
                return mz1.compareTo(mz2);
            }
        });
        return list;
    }
}

