% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specificDropoutMechanisms.R
\name{LinearRateChangeDrop}
\alias{LinearRateChangeDrop}
\title{Create a Dropout Mechanism with drop out rate which changes by a fixed constant
after every event}
\usage{
LinearRateChangeDrop(starting.rate, rate.change, var = 0)
}
\arguments{
\item{starting.rate}{\code{C}, see description section.}

\item{rate.change}{\code{D}, see description section. Note if \code{D<0}, \code{Cj} could be negative
for large \code{j}, this is not possible and the rate remains constant if the next change would set \code{Cj<=0}}

\item{var}{\code{sigma^2}, see description section}
}
\value{
A \code{DropoutMechanism} object
}
\description{
Creates an MAR \code{DropoutMechanism} object where subject \code{i} has piecewise exponential
dropout rate where the rate changes by a constant amount after each event, specifically after \code{j} events
the subject has rate \code{Rij = Cj*exp(Xij)} where \code{Cj=C+j*D} for constants \code{C}, \code{D} 
and Xij is a standard normal variable with mean 0 and standard deviation \code{sigma}
}
\examples{
LinearRateChangeDrop(starting.rate=0.0025,rate.change=0.0005)
LinearRateChangeDrop(starting.rate=0.0025,rate.change=-0.00001,var=1)
}
\seealso{
\code{\link{DropoutMechanism.object}}
}
