\name{pcf.greedy.kernel}
\alias{pcf.greedy.kernel}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Computes a discretized kernel estimator with an adaptive partition
}
\description{
Computes a discretized kernel estimator with an adaptive partition
and the output is a piecewise constant function object.
}
\usage{
pcf.greedy.kernel(dendat, h, leaf=round(dim(dendat)[1]/2), minobs=NULL,
type="greedy")
}
\arguments{
  \item{dendat}{n*d matrix of real numbers; the data matrix}
  \item{h}{d vector of positive real numbers; vector of smoothing parameters}
  \item{leaf}{positive integer}
  \item{minobs}{positive integer smaller than n; the partition is such that
   there are at most "minobs" observation in each member}
  \item{type}{a character string; 
   "greedy" (partition is generated by binary splits using maximum likelihood),
   "cpp" (just like "greedy" but uses C++ code, which is not a part of the
   package but has to loaded separately, see home page of delt),
   "dyadic" (only splits at the midpoints are made, which leads to a loss
   of accuracy), "prune" (using CART pruning), 
   "old" (not recommended).}
}
%\details{}
\value{
a piecewise constant function object with an adaptive partition, see the web site
}
%\references{http://www.rni.helsinki.fi/~jsk/d/}
\author{Jussi Klemela}
%\note{ ~~further notes~~ }

\seealso{
\code{\link{densplit}}
}

\examples{
library(denpro)
# generate data
seed<-1
n<-50
d<-2
l<-3; D<-4; c<-D/sqrt(2)
M<-matrix(0,l,d); M[2,]<-c; M[3,]<--c
sig<-matrix(1,l,d)
p<-rep(1/l,l)
dendat<-sim.data(type="mixt",n=n,M=M,sig=sig,p=p,seed=seed)

# colored volume function 
h<-(4/(d+2))^(1/(d+4))*n^(-1/(d+4))*apply(dendat,2,sd)
minobs<-1
pcf<-pcf.greedy.kernel(dendat,h,minobs=minobs,type="greedy")
#lst<-leafsfirst.adagrid(pcf)
#plotvolu(lst,colo=TRUE)

#dp<-draw.pcf(pcf)
#contour(dp$x,dp$y,dp$z,drawlabels=FALSE)
}
\keyword{multivariate}% at least one, from doc/KEYWORDS
\keyword{smooth}% __ONLY ONE__ keyword per line


