% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendro.resample.R
\name{dendro.resample}
\alias{dendro.resample}
\title{Resampling temporal resolution of dendrometer  and climate data}
\usage{
dendro.resample(df, by, value)
}
\arguments{
\item{df}{dataframe with first column containing date and time in the format \code{yyyy-mm-dd HH:MM:SS}.}

\item{by}{either \emph{H, D, W} or \emph{M} to resample data into hourly, daily, weekly or monthly resolution.}

\item{value}{either \emph{max, min}, \emph{mean} or \emph{sum} for the resampling value.}
}
\value{
Dataframe with resampled data.
}
\description{
This function is designed to change the temporal resolution of data. Depending on the objective, the user can define either maximum, minimum, or mean values to resample data in hourly, daily, weekly or monthly frequency.
}
\examples{
library(dendRoAnalyst)
data(nepa17)
# To resample monthly with maximum value
resample_M<-dendro.resample(df=gf_nepa17[,1:2], by='M', value='max')
head(resample_M,10)

}
