% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_measures.R
\name{calculate_measures}
\alias{calculate_measures}
\title{calculate_measures}
\usage{
calculate_measures(train_predicted, test_predicted, train_observed,
  test_observed)
}
\arguments{
\item{train_predicted}{a vector indicating predicted data for training set}

\item{test_predicted}{a vector indicating predicted data for testing set}

\item{train_observed}{a vector indicating observed data for training set}

\item{test_observed}{a vector indicating observed data for training set}
}
\value{
a data frame of calculated test and train measures
}
\description{
Calculates performance measures for train and test data. Calculated
performance measures are correlation coefficient (r), root mean squared
error (RMSE), root relative squared error (RSSE), index of agreement
(d), reduction of error (RE) coefficient of efficiency (CE) and bias.
}
\examples{
data(example_dataset_1)
test_data <- example_dataset_1[1:30, ]
train_data <- example_dataset_1[31:55, ]
lin_mod <- lm(MVA ~., data = train_data)
train_predicted <- predict(lin_mod, train_data)
test_predicted <- predict(lin_mod, test_data)
train_observed <- train_data[, 1]
test_observed <- test_data[, 1]
calculate_measures(train_predicted, test_predicted, train_observed,
test_observed)

test_data <- example_dataset_1[1:20, ]
train_data <- example_dataset_1[21:55, ]
library(brnn)
lin_mod <- brnn(MVA ~., data = train_data)
train_predicted <- predict(lin_mod, train_data)
test_predicted <- predict(lin_mod, test_data)
train_observed <- train_data[, 1]
test_observed <- test_data[, 1]
calculate_measures(train_predicted, test_predicted, train_observed,
test_observed)
}
\references{
Briffa, K.R., Jones, P.D., Pilcher, J.R., Hughes, M.K., 1988. Reconstructing
summer temperatures in northern Fennoscandinavia back to A.D.1700 using tree
ring data from Scots Pine. Arct. Alp. Res. 20, 385-394.

Fritts, H.C., 1976. Tree Rings and Climate. Academic Press, London 567 pp.

Lorenz, E.N., 1956. Empirical Orthogonal Functions and Statistical Weather
Prediction. Massachusetts Institute of Technology, Department of Meteorology.

Willmott, C.J., 1981. On the validation of models. Phys. Geogr. 2, 184-194.

Witten, I.H., Frank, E., Hall, M.A., 2011. Data Mining: Practical Machine
Learning Tools and Techniques, 3rd ed. Morgan Kaufmann Publishers, Burlington
629 pp.
}
