% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estim_delta.R
\name{estim_delta}
\alias{estim_delta}
\title{Estimates delta for Iterated Stable Autoencoder}
\usage{
estim_delta(X, delta = seq(0.1, 0.9, length.out = 9), nbsim = 10,
  noise = "Binomial", transformation = c("None", "CA"), pNA = 0.1,
  maxiter = 1000, threshold = 1e-08)
}
\arguments{
\item{X}{a data frame or a matrix with count}

\item{delta}{vector, a sequence of values for the probability of deletion of each cell of
the data matrix}

\item{nbsim}{number of times that pNA values are inserted and predicted in the data}

\item{noise}{noise model assumed for the data. By default and only available "Binomial"}

\item{transformation}{estimates a transformation of the original matrix; currently,
only correspondence analysis CA is available}

\item{pNA}{percentage of missing values added in the data set}

\item{maxiter}{integer, maximum number of iterations of the iterative imputation algorithm}

\item{threshold}{for assessing convergence of the iterative imputation algorithm (difference between two successive iterations)}
}
\value{
msep, matrix with the MSEP obtained for each simulation and each value of delta

delta, value giving in average the smallest MSEP over the nbsim simulations
}
\description{
This function uses cross-validation to estimate delta for the Iterated Stable Autoencoder when considering Binomial noise. delta is the probability of deletion of each cell of
             the data matrix
}
\details{
For each value delta, repeated learning cross-validation consists in inserting pNA percentage of missing values in the data set and predicting them with the Iterative Stable Autoencoder. More precisely, the prediction is obtained using the iterative imputation algorithm (imputecount) which alternates steps of imputation of the missing entries and estimation of the low-rank signal.   
This process is repeated nbsim times for all the deltas. The mean squared error of prediction is kept for each simulation and value of delta. The value of delta leading to the smallest MSEP on average over the simulations is given.
}
\examples{
 # A regularized Correspondence Analysis 
 \dontrun{library(FactoMineR)
 perfume <-  read.table("http://factominer.free.fr/docs/perfume.txt",header=TRUE,
 sep="\\t",row.names=1)
 rownames(perfume)[4] <- "Cinema"
 
 isa.delt <- estim_delta(perfume, nbsim = 10, transformation = "CA")
 
 isa.ca <- ISA(perfume, delta = isa.delt$delta, noise = "Binomial", transformation = "CA")
 rownames(isa.ca$mu.hat) <- rownames(perfume)
 colnames(isa.ca$mu.hat) <- colnames(perfume)
 res.isa.ca <- CA(isa.ca$mu.hat, graph = FALSE)
 plot(res.isa.ca, title = "Regularized CA", cex = 0.6, selectCol = "contrib 20")}
}
\seealso{
\code{\link{imputecount}}

\code{\link{ISA}}
}

