% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paired_test_continuous.R
\name{paired_test_continuous}
\alias{paired_test_continuous}
\title{Paired test for continuous variables}
\usage{
paired_test_continuous(group, x)
}
\arguments{
\item{group}{(fct) vector of groups}

\item{x}{(num) vector of observations. Note: length of `x` is
considered equal to the number of subjects by the number of
groups. Observation must be provided by subject
(e.g. c(a1, b1, c1, a2, b2, c2, a3, b3, c3, a4, b4, c4), where
the letters, a, b, c, and d represents the groups and the
numbers represents the patients' ids). Note only patient with
observation in all the levels considered will be used.}
}
\value{
A list with components
        `P` (the computed P-value),
        `stat` (the test statistic, either t or F),
        `df` (degrees of freedom),
        `testname` (test name),
        `statname` (statistic name),
        `namefun` ("paired_tstat", "rep_aov"),
        `latexstat` (LaTeX representation of statname),
        `plotmathstat` (for R - the plotmath representation of
            `statname`, as a character string),
        `note` (contains a character string note about the test).
}
\description{
Statistical tests for paired continuous variable.
}
\details{
If the test is requested for two paired groups, the
\code{\link[stats]{t.test}} is used.

If the test is requested for more than two groups, the test based on
ANOVA for repeated measures is used (powered by
\code{\link[stats]{aov}})
}
\note{
This function could be used as `conTest` option in the
\code{\link[Hmisc]{summary.formula}} with method `reverse`.
}
\examples{
\donttest{
  library(Hmisc)

  ## two groups
  summary(Species ~ .,
    data = iris[iris$Species != "setosa", ],
    method = "reverse",
    test = TRUE,
    conTest = paired_test_continuous
  )

  ## more than two groups
  summary(Species ~ .,
    data = iris,
    method = "reverse",
    test = TRUE,
    conTest = paired_test_continuous
  )

  ## without Hmisc
  two_obs <- iris$Sepal.Length[iris$Species != "setosa"]
  two_groups <- iris$Species[iris$Species != "setosa"]
  paired_test_continuous(two_groups, two_obs)

  obs <- iris$Sepal.Length
  many_groups <- iris$Species
  paired_test_continuous(many_groups, obs)
}
}
