% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asianmontecarlo.R
\name{geomasianmc}
\alias{geomasianmc}
\title{Geometric Asian option prices computed by Monte Carlo}
\usage{
geomasianmc(s, k, v, r, tt, d, m, numsim, printsds=FALSE)
}
\arguments{
\item{s}{Price of underlying asset}

\item{k}{Strike price of the option. In the case of average strike
options, \code{k/s} is the multiplier for the average}

\item{v}{Volatility of the underlygin asset price, defined as the
annualized standard deviation of the continuously-compounded
return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{m}{Number of prices in the average calculation}

\item{numsim}{Number of Monte Carlo iterations}

\item{printsds}{Print standard deviation for the particular Monte
Carlo calculation}
}
\value{
Array of geometric average option prices, along with
    vanilla European option prices implied by the the
    simulation. Optionally returns Monte Carlo standard
    deviations. Note that exact solutions for these prices exist,
    the purpose is to see how the Monte Carlo prices behave.
}
\description{
Geometric average Asian option prices
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0; m=3; numsim=1e04
geomasianmc(s, k, v, r, tt, d, m, numsim, printsds=FALSE)
}
\seealso{
Other Asian: \code{\link{arithasianmc}},
  \code{\link{arithavgpricecv}}, \code{\link{asiangeomavg}}
}
