% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bondsimple.R
\name{bondsimple}
\alias{bondsimple}
\alias{bondpv}
\alias{bondyield}
\alias{duration}
\alias{convexity}
\title{Simple Bond Functions}
\usage{
bondpv(coupon, mat, yield, principal, freq)
bondyield(price, coupon, mat, principal, freq)
duration(price, coupon, mat, principal, freq, modified)
convexity(price, coupon, mat, principal, freq)
}
\arguments{
\item{coupon}{annual coupon}

\item{mat}{maturity in years}

\item{yield}{annual yield to maturity. If freq > 1, the yield is
freq times the per period yield.}

\item{principal}{maturity payment of the bond, in addition to the
final coupon. Default value is $1,000. If the instrument is an
annuity, set principal to zero.}

\item{freq}{number of payments per year.}

\item{price}{price of the bond}

\item{modified}{If true, compute modified duration, otherwise
compute Macaulay duration. FALSE by default.}
}
\value{
Return price, yield, or duration/convexity.
}
\description{
Basic yield, pricing, duration and convexity
    calculations. These functions perform simple present value
    calculations assuming that all periods between payments are the
    same length. Unlike bond functions in Excel, for example,
    settlement and maturity dates are not used. By default,
    duration is Macaulay duration.
}
\examples{
coupon <- 6; mat <- 20; freq <- 2; principal <- 100; yield <- 0.045;

price <- bondpv(coupon, mat, yield, principal, freq) # 119.7263
bondyield(coupon, mat, price=price, principal, freq) # 0.045
duration(price, coupon, mat, principal, freq, modified=FALSE) # 12.5043
duration(price, coupon, mat, principal, freq, modified=TRUE) # 12.3928
convexity(price, coupon, mat, principal, freq) # 205.3245

}
