% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-describe.R
\name{ds_kurtosis}
\alias{ds_kurtosis}
\title{Kurtosis}
\usage{
ds_kurtosis(x, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector containing the values whose kurtosis is to be computed}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}
}
\value{
Kurtosis of \code{x}
}
\description{
Compute the kurtosis of a probability distribution.
}
\details{
Any NA values are stripped from \code{x} before computation
takes place.
}
\examples{
ds_kurtosis(mtcars$mpg)
}
\references{
Sheskin, D.J. (2000) Handbook of Parametric and Nonparametric Statistical Procedures, Second Edition. Boca Raton, Florida: Chapman & Hall/CRC.
}
\seealso{
\code{ds_skewness}
}
