% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_Runs}
\alias{plot_Runs}
\title{Function to plot runs per individual}
\usage{
plot_Runs(runs, suppressInds = FALSE, savePlots = FALSE,
  separatePlots = FALSE, outputName = NULL)
}
\arguments{
\item{runs}{a data.frame with runs per individual (group, id, chrom, nSNP, start, end, length)}

\item{suppressInds}{shall we suppress individual IDs on the y-axis? (defaults to FALSE)}

\item{savePlots}{should plots be saved out to files (one pdf file for all chromosomes)
or plotted in the graphical terminal (default)?}

\item{separatePlots}{should plots for each chromosome be saved out to separate files?}

\item{outputName}{title prefix (the base name of graph, if savePlots is TRUE)}
}
\value{
plot of runs by chromosome
}
\description{
Function to plot runs per individual (see Williams et al. 2016, Animal Genetics,
for an example with animal data)
Individual IDs on the y-axis, bps on the x-axis (position along the chromosome)
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF <- readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

# plot runs per animal (interactive)
plot_Runs(runs = runsDF, suppressInds = FALSE, savePlots = FALSE, outputName = "ROHom")

}
