% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_fitAll.R
\name{devRateModelAll}
\alias{devRateModelAll}
\title{Fitting all models listed in devRateEqList to a development rate dataset}
\usage{
devRateModelAll(
  dfData,
  eqList = devRate::devRateEqList,
  eqStartVal = devRate::devRateEqStartVal,
  propThresh = 0.01,
  interval = c(0, 50),
  ...
)
}
\arguments{
\item{dfData}{A data.frame with the temperature in the first column and the
development rate in the second column.}

\item{eqList}{A list of models that can be retrieved from the object devRateEqList.
The default value is the object devRateEqList.}

\item{eqStartVal}{A list of sarting values for each model. The default value is
the object devRateEqStartVal.}

\item{propThresh}{The proportion of maximal development rate used as a
threshold for estimating XTmin and XTmax for asymptotic equations
(default value is 0.01)}

\item{interval}{A vector containing the lower and upper boundaries of the
interval of temperatures in which metrics are searched.}

\item{...}{Additional arguments for the \code{devRateModel} function.}
}
\value{
An object of class \code{list} with two elements. The first
element is a \code{list} with all the nls objects resulting from the fitting
of the models. The second element is a \code{data.frame}.
The first column corresponds to models' names and the second column corresponds
to the number of parameters of the models. The columns 3 and 4 correspond
to the results of the function \code{devRateQlStat}. The columns 5 to 9
correspond to the results of the function \code{devRateQlBio}. The column 10
shows the AIC of each model, the column 11 shows BIC of each model.
}
\description{
This function fits all models listed in devRateEqList to a development
rate dataset and then calculates a series of indices of goodness of fit for
each fitted model.
}
\details{
Equations stinner_74 and lamb_92 are fitted and the resulting nls objects
are showed in the first element of the returned list, however indices of goodness
of fit are not provided as these equations return a list of two nls objects.
Equation campbell_74 is not fitted.
}
\examples{
myDf <- exTropicalMoth$raw$egg
devRateModelAll(dfData = myDf)
}
