% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aov.R
\name{visualize_aov}
\alias{visualize_aov}
\title{Visualize AOV Outcomes}
\usage{
visualize_aov(
  aov_results,
  show_main = TRUE,
  num_plots = 8,
  horizontal = TRUE,
  axis_label_style = 1,
  ...
)
}
\arguments{
\item{aov_results}{A \code{list} containing the AOV results.}

\item{show_main}{\code{logical} indicating if the main effects and total sums
of squares should be included in the visualization. Default is \code{TRUE}.}

\item{num_plots}{\code{numeric} specifying the count of effects to be
showcased in the display.}

\item{horizontal}{\code{logical} determining if the bar plots should be
oriented horizontally. Default is \code{TRUE}.}

\item{axis_label_style}{\code{numeric} designating the label styling for the
plot's axes. Default is 1.}

\item{...}{Additional arguments affecting the bar plot's aesthetics.}
}
\value{
A \code{data.frame} containing proportions derived from the sum of
squares.
}
\description{
Renders the outcomes of an Analysis of Variance (AOV) through bar plots,
allowing a comprehensive display of both total sums and specific effects.
}
\examples{
tree <- dexisensitivity::masc2
subtree <- create_sub_tree(tree, "Dimension sociale")
AOV_out <- aov_tree(subtree)
visualize_aov(AOV_out)

}
