% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enorm.R
\name{fit_enorm_mst}
\alias{fit_enorm_mst}
\title{Fit the extended nominal response model on MST data}
\usage{
fit_enorm_mst(db, predicate = NULL, fixed_parameters = NULL)
}
\arguments{
\item{db}{an dextermst db handle}

\item{predicate}{logical predicate to select data to include in the analysis, see details}

\item{fixed_parameters}{data.frame with columns `item_id`, `item_score` and `beta`}
}
\value{
object of type 'mst_enorm'. Can be cast to a data.frame of item parameters 
using function `coef` or used in dexter's \code{\link[dexter]{ability}} functions
}
\description{
Fits an Extended NOminal Response Model (ENORM) using conditional maximum likelihood (CML)
}
\details{
You can use the predicate to include or omit responses from the analysis, e.g.
 `p = fit_enorm_mst(db, item_id != 'some_item' & student_birthdate > '2005-01-01')`
 
DexterMST will automatically correct the routing rules for the purpose of the current analysis. 
There are some caveats though. Predicates that lead to many different designs, e.g. a predicate like
\code{response != 'NA'} (which is perfectly valid but can potentially create 
almost as many tests as there are students) might take very long to compute. 

Predicates that remove complete modules from a test, e.g. \code{module_nbr !=2} or \code{module_id != 'RU4'} 
will cause an error and should be avoided.
}
\references{
Zwitser, R. J. and Maris, G (2015); Conditional statistical inference with multistage testing designs. 
Psychometrika. Vol. 80, no. 1, 65-84.
}
