\name{nsim}
\alias{nsim}

\title{
Simulate one or more Phase I clinical trial(s) using the PK measure in the dose finding design.
}

\description{ 
nsim is used to generate "n" simulations of phase I trial using the PK data and then link them to toxicity under a specified dose-toxicity configuration. The objective is to determine the maximum tolerated dose (MTD).
}

\usage{ 
nsim(doses, N, cohort, icon, theta, model, simulatedData, TR, prob = 0.9, AUCmethod = 2, 
    options = list(nchains = 4, niter = 4000, nadapt = 0.8), betapriors = NULL, 
    thetaL=NULL, p0 = 0, L = 0)
}

\arguments{
    \item{doses}{
        A vector with the doses panel.
    }
    \item{N}{
        The total number of enrolled patients.
    }
    \item{cohort}{
        The number of cohorts in the trial.
    }
    \item{icon}{
        The index of real blood sampling.
    }
    \item{theta}{
        The toxicity target.
    }
    \item{model}{
        A character string to specify the working dose-finding model.
    }
    \item{simulatedData}{
        A generated simulated PK and toxicity data; a "scen" object. See for details \code{\link{sim.data}}.
    }
    \item{TR}{
        The number of replicates clinical trials.
    }
    \item{prob}{
        The probability of toxicity for the corresponding stopping rule of the selected model; defaults to 0.9. See for details \code{\link{dtox}}, \code{\link{pkcov}}, \code{\link{pkcrm}}, \code{\link{pktox}}, \code{\link{pkpop}}, \code{\link{pklogit}}.
    }
    \item{AUCmethod}{
        A string number specifying the method for calculation of AUC. Possible values are "1" for a compartmental method and "2" for non-compartmental method (default=2).
    }
    \item{options}{ 
        A list with the Stan model's options; the number of chains, how many iterations for each chain and the number of warmup iterations.
    defaults to options <- list(nchains = 4,
                            niter = 4000,
                            nadapt = 0.8)
    }
    \item{betapriors}{
        A vector with the value for the prior distribution of the regression parameters in the model; defaults to NULL. 
    }
    \item{thetaL}{
        A second threshold of AUC; must be defined only in the PKCRM model.
    }
    \item{p0}{
        The skeleton of CRM for pkcrm; defaults to NULL (must be defined only in the PKCRM model).
    }
    \item{L}{
        The AUC threshold to be set before starting the trial for pklogit, pkcrm and pktox; defaults to NULL (must be defined only in the PKCRM model).
    }
}

\value{
    An object of class "dosefinding" is returned, consisting of determination of the next recommended dose and estimations. Objects generated by nsim contain at least the following components:

    \item{pid}{The patient's ID during the trial.}
    \item{N}{The total number of enrolled patients.}
    \item{time}{The time sampling.}
    \item{doses}{A vector with the doses panel.}
    \item{conc}{The concentration of the drug in blood plasma.}
    \item{nchains}{The number of chains for the Stan model.}
    \item{niter}{The number of iterations for each chain in the Stan model.}
    \item{nadapt}{The number of warmup iterations.}
    \item{newDose}{The next maximum tolerated dose (MTD); equals to "NA" if the trial has stopped before the end, according to the stopping rules.}
    \item{theta}{Tocixity target.}
    \item{doseLevels}{A vector of dose levels assigned to patients in the trial.}
    \item{toxicity}{The estimated toxicity outcome.}
    \item{AUCs}{A vector with the computed AUC values of each patient.}
    \item{TR}{The number of replicates clinical trials.}
    \item{preal}{Prior toxicity probabilities.}
    \item{pstim}{The mean values of estimated probabilities of toxicity.}
    \item{pstimQ1}{The 1st quartile of estimated probabilities of toxicity.}
    \item{pstimQ3}{The 3rd quartile of estimated probabilities of toxicity.}
    \item{model}{A character string of the selected working dose-finding model.}
}

\references{
Ursino, M., et al, (2017) Dose-finding methods for Phase I clinical trials using pharmacokinetics in small populations, Biometrical Journal. 
}

\author{Artemis Toumazi \email{artemis.toumazi@inserm.fr}, 
        Moreno Ursino \email{moreno.ursino@inserm.fr},
        Sarah Zohar \email{sarah.zohar@inserm.fr}
        }


\seealso{
\code{\link{sim.data}}
}

\examples{
    \dontrun{
        TR = 10                                 # Total number of simulations                 
        N = 42                         
        limitTox <- 10.96 
        PKparameters <- c(2, 10, 100)             # PK parameters ka,CL,V
        omegaIIV <- 0.7                        
        omegaAlpha <- 0
        doses <- c(12.59972, 34.65492, 44.69007, 60.80685, 83.68946, 100.37111)     
        timeSampling <- seq(0, 24, length.out=48)    
        sigma <- rep(0.2, length(timeSampling))         

        gen.scen <- sim.data(PKparameters,omegaIIV,omegaAlpha,sigma,doses,
                             limitTox,timeSampling, N)

        cohort = 1
        simulatedData <- gen.scen  
        doses <- simulatedData@doses
        icon <- c(2:6, round(seq(9, 48, ((48-9)/4))))      
        theta <- 0.2                             

        ##############################################
        ############### Select a model ###############
        ##############################################

        model = "pktox"

        ############################################
        ############ Run the simulation(s) #########
        ############################################

        results_sim <- nsim(doses, N, cohort, icon, theta, model, simulatedData, TR, AUCmethod = 1)
        results_sim
    }
}

