\name{sim.data}
\alias{sim.data}

\title{
Generate new PK and toxicity data.
}

\description{
This function can be used to generate/simulate new data from several measurements simulations.
}

\usage{
sim.data(PKparameters, omegaIIV, omegaAlpha, sigma, doses, limitTox, 
         timeSampling, N)
}

\arguments{
  \item{PKparameters}{
Subject's pharmacokinetic's (PK) parameters. 
}
\item{omegaIIV}{
The inter-individual variability for the clearance and the volume of distribution; possible values may be 70\% or 30\% in different simulated data.
}
  \item{omegaAlpha}{
The patient's sensitivity parameter. 
}
  \item{sigma}{
The additive or proportional error.
}
  \item{doses}{
A vector with the doses panel. 
}
  \item{limitTox}{
The toxicity threshold.
}
  \item{timeSampling}{
The time sampling.
}
  \item{N}{
The total number of enrolled patients.  
}
}

\value{
An object of class "scen" is returned, consisting of simulated PK and toxicity data. Objects generated by sim.data contain at least the following components:

\item{PKparameters}{Subject's pharmacokinetic's (PK) parameters.}
\item{nPK}{The length of the time points.}
\item{time}{The time sampling.}
\item{N}{The total number of enrolled patients.}
\item{doses}{A vector with the doses panel.}
\item{preal}{Prior toxicity probabilities.}
\item{limitTox}{Tocixity threshold.}
\item{omegaIIV}{The inter-individual variability for the clearance and the volume of distribution.}
\item{omegaAlpha}{The patient's sensitivity parameter.}
\item{conc}{The concentration of the drug in blood plasma.}
\item{concPred}{The predicted concentration of the drug in blood plasma.}
\item{tox}{The toxicity outcome.}
\item{tab}{A summarized matrix consisting of the predicted concentration of the drug and the time sampling for each patient.}
\item{parameters}{The estimated PK parameters of each patient.}
\item{alphaAUC}{A vector with the computed AUC values of each patient.}
}

\references{
Ursino, M., et al, (2017) Dose-finding methods for Phase I clinical trials using pharmacokinetics in small populations, Biometrical Journal.
}

\author{Artemis Toumazi \email{artemis.toumazi@inserm.fr}, 
        Moreno Ursino \email{moreno.ursino@inserm.fr},
        Sarah Zohar \email{sarah.zohar@inserm.fr}
        }
        
\seealso{
\code{\link{nsim}}
}

\examples{
limitTox <- 10.96                  
N <- 42                               
PKparameters <- c(2,10,100)       # PK parameters ka,CL,V
omegaIIV <- 0.7                   # Inter-individual
omegaAlpha <- 0                    
doses <- c(12.59972,34.65492,44.69007,60.80685,83.68946,100.37111)
timeSampling <- seq(0,24,length.out=48)    
sigma <- rep(0.2,length(timeSampling))  # sigma: Additive or proportional error

gen.scen <- sim.data(PKparameters,omegaIIV,omegaAlpha,sigma,doses,limitTox,timeSampling, N) 
gen.scen
}

\keyword{models}