\name{dtox}
\alias{dtox}
\title{
Dose finding method DTOX.
}

\description{
The DTOX model enables us to estimate posterior probability of toxicity \eqn{p_T} versus dose directly. The dose-toxicity model is given by:

\deqn{p_T(d_k,\boldsymbol{\beta}) = \Phi(-\beta_0 + \beta_1 log(d_k))}

where \eqn{\beta_q \sim U(l_q, u_q)} \eqn{\forall} \eqn{q = 0,1} and
\deqn{beta0mean = c(l_0, u_0),}
\deqn{beta1mean = c(l_1, u_1)}
where default choices are beta0mean = c(0, 16.71) and beta1mean = c(0, 6.43). So the default choices for model's priors are given by \deqn{betapriors = c(l_0 = 0, u_0 = 16.71, l_1 = 0, u_1 = 6.43)}

Finally, the DTOX model has the following stopping rule in toxicity:
if
\deqn{P(p_T(dose) > theta) > prob}
then, no dose is suggested and the trial is stopped. 
}

\usage{
dtox(y, doses, x, theta, prob = 0.9, options=list(nchains = 4, niter = 4000, 
     nadapt = 0.8), betapriors = c(0, 16.71, 0, 6.43), thetaL = NULL, 
     auc = NULL, deltaAUC = NULL, p0 = NULL, L = NULL, CI = TRUE)
}

\arguments{
\item{y}{
    A binary vector of patient's toxicity outcomes; TRUE indicates a toxicity, FALSE otherwise.
}
\item{doses}{
    A vector with the doses panel.
}
\item{x}{
    A vector with the dose level assigned to the patients.
}
\item{theta}{
    The toxicity target.
}
\item{prob}{
    The threshold of the posterior probability of toxicity for the stopping rule; defaults to 0.9.
}
\item{betapriors}{
    A vector with the value for the prior distribution of the regression parameters in the model; defaults to betapriors = c(beta0mean, beta1mean), where beta0mean = c(0, 16.71) and beta1mean = c(0, 6.43).
}
\item{options}{
    A list with the Stan model's options; the number of chains, how many iterations for each chain and the number of warmup iterations; defaults to options = list(nchains = 4, niter = 4000, nadapt = 0.8).
}
\item{auc}{
    A vector with the computed AUC values of each patient for pktox, pkcrm, pklogit and pkpop; defaults to NULL.  
}
\item{deltaAUC}{
    The difference between computed individual AUC and the AUC of the population at the same dose level (defined as an average); argument for pkcov; defaults to NULL.
}
\item{p0}{
    The skeleton of CRM for pkcrm; defaults to NULL (must be defined only in the PKCRM model).
}
\item{L}{
    The AUC threshold to be set before starting the trial for pklogit, pkcrm and pktox; defaults to NULL (must be defined only in the PKCRM model).
}
\item{thetaL}{
    A second threshold of AUC; must be defined only in the PKCRM model.
}
\item{CI}{
    A logical constant indicating the estimated 95\% credible interval; defaults to TRUE.
}
}

\value{
A list is returned, consisting of determination of the next recommended dose and estimations of the model. Objects generated by dtox contain at least the following components:

\item{newDose}{The next maximum tolerated dose (MTD); equals to "NA" if the trial has stopped before the end, according to the stopping rules.}
\item{pstim}{The mean values of estimated probabilities of toxicity.}
\item{p_sum}{The summary of the estimated probabilities of toxicity if CI = TRUE, otherwise is NULL.}
\item{parameters}{The estimated model's parameters.}
}

\references{
Ursino, M., et al, (2017) Dose-finding methods for Phase I clinical trials using pharmacokinetics in small populations, Biometrical Journal.
}

\author{Artemis Toumazi \email{artemis.toumazi@inserm.fr},
        Moreno Ursino \email{moreno.ursino@inserm.fr},
        Sarah Zohar \email{sarah.zohar@inserm.fr}
        }

\seealso{
\code{\link{sim.data}}, \code{\link{nsim}}, \code{\link{nextDose}}
}

\examples{
doses <- c(12.59972,34.65492,44.69007,60.80685,83.68946,100.37111)
theta <- 0.2
options <- list(nchains = 2, niter = 4000, nadapt = 0.8)
x <- c(1,2,3,4,5,6)
y <- c(FALSE,FALSE,FALSE,FALSE,TRUE,FALSE)

res <- dtox(y, doses, x, theta, options = options)
}

\keyword{models}
