% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-dgirtfit.r
\docType{methods}
\name{show,dgo_fit-method}
\alias{show,dgo_fit-method}
\alias{print,dgo_fit-method}
\alias{print.dgo_fit}
\alias{get_elapsed_time,dgo_fit-method}
\alias{summary,dgo_fit-method}
\alias{get_posterior_mean,dgo_fit-method}
\alias{summarize}
\alias{summarize,dgo_fit-method}
\alias{as.data.frame.dgo_fit}
\alias{rhats}
\alias{rhats,dgo_fit-method}
\title{\code{print} method for \code{dgo_fit-class} objects}
\usage{
\S4method{show}{dgo_fit}(object)

\S4method{print}{dgo_fit}(x, ...)

print.dgo_fit(x, ...)

\S4method{get_elapsed_time}{dgo_fit}(object, ...)

\S4method{summary}{dgo_fit}(object, ..., verbose = FALSE)

\S4method{get_posterior_mean}{dgo_fit}(object, pars = "theta_bar", ...)

summarize(x, ...)

\S4method{summarize}{dgo_fit}(x, pars = "theta_bar", funs = c("mean", "sd",
  "median", "q_025", "q_975"))

\method{as.data.frame}{dgo_fit}(x, ..., pars = "theta_bar",
  keep.rownames = FALSE)

rhats(x, ...)

\S4method{rhats}{dgo_fit}(x, pars = "theta_bar")
}
\arguments{
\item{object}{A \code{dgo_fit-class} object}

\item{x}{A \code{dgo_fit-class} object}

\item{...}{Further arguments to \code{\link{stanfit-class}} methods.}

\item{verbose}{Whether to show the full output from the \code{rstan} method.}

\item{pars}{Parameter name(s)}

\item{funs}{Quoted names of summary functions. `q_025` is accepted as
shorthand for `function(x) quantile(x, .025)`, and similarly `q_975`.}

\item{keep.rownames}{Whether to retain original parameter names with numeric
indexes, as output from RStan.}
}
\value{
A table giving split R-hats for model parameters
}
\description{
\code{print} method for \code{dgo_fit-class} objects

\code{get_elapsed_time}: extract chain run times from \code{dgo_fit}-class
objects

\code{summary} method for \code{dgo_fit-class} objects

\code{summarize} method for \code{dgo_fit-class} objects

\code{as.data.frame} method for \code{dgo_fit-class} objects

\code{rhats}: extract split R-hats from \code{dgo_fit}-class objects
}
\examples{
data(toy_dgirtfit)
summarize(toy_dgirtfit)
data(toy_dgirtfit)
# access posterior samples
as.data.frame(toy_dgirtfit, pars = 'theta_bar')
data(toy_dgirtfit)
rhats(toy_dgirtfit)
}
