% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_degree.R
\name{degree}
\alias{degree}
\alias{degree_int}
\alias{spline_degree}
\alias{prod_degree}
\title{Parameters for exponents}
\usage{
degree(range = c(1, 3), trans = NULL)

degree_int(range = c(1L, 3L), trans = NULL)

spline_degree(range = c(1L, 10L), trans = NULL)

prod_degree(range = c(1L, 2L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
These parameters help model cases where an exponent is of interest (e.g.
\code{degree()} or \code{spline_degree()}) or a product is used (e.g. \code{prod_degree}).
}
\details{
\code{degree()} is helpful for parameters that are real number exponents (e.g.
\code{x^degree}) whereas \code{degree_int()} is for cases where the exponent should be
an integer.

The difference between \code{degree_int()} and \code{spline_degree()} is the default ranges
(which is based on the context of how/where they are used).

\code{prod_degree()} is used by \code{parsnip::mars()} for the number of terms in
interactions (and generates an integer).
}
\examples{
degree()
degree_int()
spline_degree()
prod_degree()
}
