% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifelse.R
\name{ifelse}
\alias{ifelse}
\alias{ifelse.default}
\alias{ifelse.tbl_ddf}
\alias{ifelse.ddf_col}
\title{Conditional element selection}
\usage{
ifelse(test, yes, no, ...)

\method{ifelse}{default}(test, yes, no, ...)

\method{ifelse}{tbl_ddf}(test, yes, no, ...)

\method{ifelse}{ddf_col}(test, yes, no, ...)
}
\arguments{
\item{test}{An object which can be coerced to logical mode.}

\item{yes}{Return values for true elements of test.}

\item{no}{Return values for false elements of test.}

\item{...}{Unused, for extensibility.}
}
\value{
A dibble if test is a dibble. See \code{\link[base:ifelse]{base::ifelse()}} for the return
value of the default method.
}
\description{
Selects elements from either \code{yes} or \code{no} depending on whether \code{test} is
\code{TRUE} or \code{FALSE}.
}
\details{
\code{ifelse()} overrides \code{\link[base:ifelse]{base::ifelse()}} to make it generic. The default method
calls the base version.
}
\seealso{
\code{\link[base:ifelse]{base::ifelse()}}.
}
