% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_knn}
\alias{impute_knn}
\title{K-Nearest Neighbours imputation}
\usage{
impute_knn(x, data, seed = 123456)
}
\arguments{
\item{x}{clustering object}

\item{data}{data matrix}

\item{seed}{random seed for knn imputation reproducibility}
}
\value{
An object with (potentially not all) missing values imputed with
K-Nearest Neighbours.
}
\description{
The non-missing cases indicate the training set, and missing cases indicate
the test set.
}
\note{
We consider 5 nearest neighbours and the minimum vote for definite
decision is 3.
}
\examples{
data(hgsc)
dat <- hgsc[1:100, 1:50]
x <- consensus_cluster(dat, nk = 4, reps = 4, algorithms = c("km", "hc",
"diana"), progress = FALSE)
x <- apply(x, 2:4, impute_knn, data = dat, seed = 1)
}
\seealso{
Other imputation functions: 
\code{\link{impute_missing}()}
}
\author{
Aline Talhouk
}
\concept{imputation functions}
