% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importPolarized.r
\name{importPolarized}
\alias{importPolarized}
\title{Imports genomic data polarized according to the specification}
\usage{
importPolarized(
  files,
  changePolarity,
  ChosenInds,
  ChosenSites = "all",
  nCores = 1,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{files}{character vector with paths to files with genotypes.}

\item{changePolarity}{logical vector with length equal to the number of markers.}

\item{ChosenInds}{numeric vector of indices of individuals to be included in the analysis.}

\item{ChosenSites}{logical vector indicating which sites are to be included in the
analysis.}

\item{nCores}{numeric. Number of cores to be used for parallelisation. Must be
at most equal to the number of files in the \code{files} argument, and
\code{nCores = 1} on Windows.}

\item{verbose}{logical whether to show messages on import progress.}

\item{...}{optional numeric vector of \code{compartmentSizes}.}
}
\value{
Returns a character matrix with rows containing individual genotypes and columns
containing markers.
}
\description{
Reads genotypes from a file and changes marker polarity.
}
\details{
For details on the input data format, check the \code{file} with
\link{CheckDiemFormat}.

The \code{changePolarity} argument influences how each marker is imported. Value
\code{FALSE} means that the marker will be imported as it is saved in the \code{file}. Value
\code{TRUE} means that the genotypes encoded as \code{0} will be imported as \code{2}, and genotypes
encoded in the \code{file} as \code{2} will be imported as \code{0}.
}
\examples{
dat <- importPolarized(
  files = system.file("extdata", "data7x3.txt", package = "diemr"),
  changePolarity = c(FALSE, TRUE, TRUE),
  ChosenInds = 1:6,
  ChosenSites = "all"
)
dat
#    m1  m2  m3
# 1 "0" "1" "2"
# 2 "0" "0" "0"
# 3 "1" "1" "0"
# 4 "1" "2" "0"
# 5 "2" "2" "1"
# 6 "2" "2" "_"
}
\seealso{
\link{diem} for determining appropriate marker polarity with
respect to a barrier to geneflow.
}
