#' Key of Correct Answers for \code{GMAT2test} Data Set
#'
#' @description The \code{GMAT2key} is a vector of factors representing correct answers of generated
#' \code{GMAT2test} data set based on Graduate Management Admission Test (GMAT) data set (Kingston et al., 1985).
#'
#' @usage data(GMAT2key)
#'
#' @author
#' Adela Drabinova \cr
#' Institute of Computer Science, The Czech Academy of Sciences \cr
#' Faculty of Mathematics and Physics, Charles University \cr
#' drabinova@cs.cas.cz \cr
#'
#' Patricia Martinkova \cr
#' Institute of Computer Science, The Czech Academy of Sciences \cr
#' martinkova@cs.cas.cz \cr
#'
#' @references
#' Kingston, N., Leary, L., & Wightman, L. (1985). An Exploratory Study of the Applicability of Item Response
#' Theory Methods to the Graduate Management Admission Test. ETS Research Report Series, 1985(2) : 1-64.
#'
#' Drabinova, A. & Martinkova P. (2017). Detection of Differential Item Functioning with NonLinear Regression:
#' Non-IRT Approach Accounting for Guessing. Journal of Educational Measurement, 54(4), 498-517.
#'
#' @keywords datasets
#'
#' @seealso \code{\link{GMAT2}}, \code{\link{GMAT2test}}
#'
#' @format A data frame with 20 values representing correct answers to items of \code{GMAT2test} data set.
#' For more details see \code{\link{GMAT2test}}.
"GMAT2key"
#> [1] "GMAT2key"
