# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Generate Multinomial Random Variable
#' @description Sample a multinomial random variable for given probabilities. 
#' @usage rmultinomial(ps)
#' @param ps A \code{vector} for the probability of each category.
#' @return A \code{vector} from a multinomial with probability ps.
#' @author Steven Andrew Culpepper
#' 
rmultinomial <- function(ps) {
    .Call('dina_rmultinomial', PACKAGE = 'dina', ps)
}

#' @title Generate Dirichlet Random Variable
#' @description Sample a Dirichlet random variable. 
#' @usage rDirichlet(deltas)
#' @param deltas A \code{vector} of Dirichlet parameters.
#' @return A \code{vector} from a Dirichlet.
#' @author Steven Andrew Culpepper
#' 
rDirichlet <- function(deltas) {
    .Call('dina_rDirichlet', PACKAGE = 'dina', deltas)
}

#' @title Simulation Responses from the DINA model
#' @description Sample responses from the DINA model for given attribute profiles, Q matrix, and item parmeters. 
#' @usage DINAsim(alphas,Q,ss,gs)
#' @param alphas A N by K \code{matrix} of latent attributes.
#' @param Q A N by K \code{matrix} indicating which skills are required for which items.
#' @param ss A J \code{vector} of item slipping parameters.
#' @param gs A J \code{vector} of item guessing parameters.
#' @return A N by J \code{matrix} of responses from the DINA model.
#' @author Steven Andrew Culpepper
#' 
DINAsim <- function(alphas, Q, ss, gs) {
    .Call('dina_DINAsim', PACKAGE = 'dina', alphas, Q, ss, gs)
}

#' @title Update attributes and latent class probabilities
#' @description Update attributes and latent class probabilities by sampling from full conditional distribution. 
#' @usage update_alpha(Amat,Q,ss,gs,Y,PIs,ALPHAS,delta0)
#' @param Amat A C by K \code{matrix} of latent classes.
#' @param Q A N by K \code{matrix} indicating which skills are required for which items.
#' @param ss A J \code{vector} of item slipping parameters.
#' @param gs A J \code{vector} of item guessing parameters.
#' @param Y A N by J \code{matrix} of observed responses.
#' @param PIs A C \code{vector} of latent class probabilities.
#' @param ALPHAS A N by K \code{matrix} of latent attributes.
#' @param delta0 A J \code{vector} of Dirichlet prior parameters.
#' @return A N by K \code{matrix} of attributes and a C \code{vector} of class probabilities.
#' @author Steven Andrew Culpepper
#' 
update_alpha <- function(Amat, Q, ss, gs, Y, PIs, ALPHAS, delta0) {
    .Call('dina_update_alpha', PACKAGE = 'dina', Amat, Q, ss, gs, Y, PIs, ALPHAS, delta0)
}

#' @title Update item parameters
#' @description Update guessing and slipping parameters from full conditional distribution. 
#' @usage update_sg(Y,Q,ALPHAS,ss_old,as0,bs0,ag0,bg0)
#' @param Y A N by J \code{matrix} of observed responses.
#' @param Q A N by K \code{matrix} indicating which skills are required for which items.
#' @param ALPHAS A N by K \code{matrix} of latent attributes.
#' @param ss_old A J \code{vector} of item slipping parameters from prior iteration.
#' @param as0 Slipping prior alpha parameter for Beta distribution.
#' @param bs0 Slipping prior beta parameter for Beta distribution.
#' @param ag0 Guessing prior alpha parameter for Beta distribution.
#' @param bg0 Guessing prior beta parameter for Beta distribution.
#' @return A list with two J \code{vectors} of guessing and slipping parameters.
#' @author Steven Andrew Culpepper
#' 
update_sg <- function(Y, Q, ALPHAS, ss_old, as0, bs0, ag0, bg0) {
    .Call('dina_update_sg', PACKAGE = 'dina', Y, Q, ALPHAS, ss_old, as0, bs0, ag0, bg0)
}

#' @title Implement Gibbs sampler
#' @description Function for sampling parameters from full conditional distributions. 
#' @usage DINA_Gibbs(Y,Amat,Q,chain_length)
#' @param Y A N by J \code{matrix} of observed responses.
#' @param Amat A C by K \code{matrix} of latent classes.
#' @param Q A N by K \code{matrix} indicating which skills are required for which items.
#' @param chain_length Number of MCMC iterations.
#' @return A list with samples from the posterior distribution.
#' @author Steven Andrew Culpepper
#' 
DINA_Gibbs <- function(Y, Amat, Q, chain_length = 10000L) {
    .Call('dina_DINA_Gibbs', PACKAGE = 'dina', Y, Amat, Q, chain_length)
}

