% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_month.R, R/get_year.R
\name{month.date_xx}
\alias{month.date_xx}
\alias{year.date_xx}
\alias{month}
\alias{year}
\title{Get Year, Quarter or Month (lubridate Compatibility)}
\usage{
month.date_xx(x, label = FALSE, abbr = TRUE,
  locale = Sys.getlocale("LC_TIME"))

year.date_xx(x)
}
\arguments{
\item{x}{a date-time object}

\item{label}{logical. TRUE will display the month as a character string such
as "January." FALSE will display the month as a number.}

\item{abbr}{logical. FALSE will display the month as a character string
label, such as "January". TRUE will display an abbreviated version of the
label, such as "Jan". abbr is disregarded if label = FALSE.}

\item{locale}{for month, locale to use for month names. Default to current locale.}
}
\description{
See \code{\link[lubridate:year]{lubridate::year()}} and \code{\link[lubridate:month]{lubridate::month()}}
}
\examples{

\dontrun{
  library(lubridate)
  month(x)
  month(x, label = TRUE)
}
}
\seealso{
\link{get_year}
}
