% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim_flexible.R, R/discrim_linear.R,
%   R/discrim_quad.R, R/discrim_regularized.R, R/naive_Bayes.R
\name{update.discrim_flexible}
\alias{update.discrim_flexible}
\alias{update.discrim_linear}
\alias{update.discrim_quad}
\alias{update.discrim_regularized}
\alias{update.naive_Bayes}
\title{Update a model specification}
\usage{
\method{update}{discrim_flexible}(
  object,
  num_terms = NULL,
  prod_degree = NULL,
  prune_method = NULL,
  fresh = FALSE,
  ...
)

\method{update}{discrim_linear}(
  object,
  penalty = NULL,
  regularization_method = NULL,
  fresh = FALSE,
  ...
)

\method{update}{discrim_quad}(object, regularization_method = NULL, fresh = FALSE, ...)

\method{update}{discrim_regularized}(
  object,
  frac_common_cov = NULL,
  frac_identity = NULL,
  fresh = FALSE,
  ...
)

\method{update}{naive_Bayes}(object, smoothness = NULL, Laplace = NULL, fresh = FALSE, ...)
}
\arguments{
\item{object}{A model specification.}

\item{num_terms}{The number of features that will be retained in the
final model, including the intercept.}

\item{prod_degree}{The highest possible interaction degree.}

\item{prune_method}{The pruning method.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}

\item{penalty}{An non-negative number representing the amount of
regularization used by some of the engines.}

\item{regularization_method}{A character string for the type of regularized
estimation. Possible values are: "\code{diagonal}", "\code{min_distance}",
"\code{shrink_cov}", and "\code{shrink_mean}" (\code{sparsediscrim} engine only).}

\item{frac_common_cov}{Numeric values between zero and one.}

\item{frac_identity}{Numeric values between zero and one.}

\item{smoothness}{An non-negative number representing the the relative
smoothness of the class boundary. Smaller examples result in model flexible
boundaries and larger values generate class boundaries that are less
adaptable}

\item{Laplace}{A non-negative value for the Laplace correction to smoothing
low-frequency counts.}
}
\description{
Update a model specification
}
