% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_FeatureHandler.R
\name{FeatureHandler}
\alias{FeatureHandler}
\title{FeatureHandler}
\value{
A new instance of the \code{FeatureHandler} \link[R6:R6Class]{R6} class.
}
\description{
This \code{FeatureHandler} \link[R6:R6Class]{R6} handles individual features for the feature stores.
They define the three methods associated with features (\code{compute}, \code{get} and \code{key_join}).
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  # The FeatureHandler is typically configured as part of making a new Diseasystore.
  # Most often, we need only specify `compute` and `key_join` to get a functioning FeatureHandler

  # In this example we use mtcars as the basis for our features
  conn <- SCDB::get_connection(drv = RSQLite::SQLite())

  # We use mtcars as our basis. First we add the rownames as an actual column
  data <- dplyr::mutate(mtcars, key_name = rownames(mtcars), .before = dplyr::everything())

  # Then we add some imaginary times where these cars were produced
  data <- dplyr::mutate(data,
                        production_start = as.Date(Sys.Date()) + floor(runif(nrow(mtcars)) * 100),
                        production_end   = production_start + floor(runif(nrow(mtcars)) * 365))

  dplyr::copy_to(conn, data, "mtcars")

  # In this example, the feature we want is the "maximum miles per gallon"
  # The feature in question in the mtcars data set is then "mpg" and when we need to reduce
  # our data set, we want to use the "max()" function.

  # We first write a compute function for the mpg in our modified mtcars data set
  # Our goal is to get the mpg of all cars that were in production at the between start/end_date
  compute_mpg <- function(start_date, end_date, slice_ts, source_conn) {
    out <- SCDB::get_table(source_conn, "mtcars", slice_ts = slice_ts) |>
      dplyr::filter({{ start_date }} <= .data$production_end,
                    .data$production_start <= {{ end_date }}) |>
      dplyr::transmute("key_name", "mpg",
                       "valid_from" = "production_start",
                       "valid_until" = "production_end")

    return(out)
  }

  # We can now combine into our FeatureHandler
  fh_max_mpg <- FeatureHandler$new(compute = compute_mpg, key_join = key_join_max)

  DBI::dbDisconnect(conn)
\dontshow{\}) # examplesIf}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{compute}}{(\code{function})\cr
A function of the form "function(start_date, end_date, slice_ts, source_conn)".
This function should compute the feature from the source connection.}

\item{\code{get}}{(\code{function})\cr
A function of the form "function(target_table, slice_ts, target_conn)".
This function should retrieve the computed feature from the target connection.}

\item{\code{key_join}}{(\code{function})\cr
One of the aggregators from \link{aggregators}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FeatureHandler-new}{\code{FeatureHandler$new()}}
\item \href{#method-FeatureHandler-clone}{\code{FeatureHandler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FeatureHandler-new"></a>}}
\if{latex}{\out{\hypertarget{method-FeatureHandler-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of the \code{FeatureHandler} \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureHandler$new(compute = NULL, get = NULL, key_join = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{compute}}{(\code{function})\cr
A function of the form "function(start_date, end_date, slice_ts, source_conn)".
This function should return a \code{data.frame} with the computed feature (computed from the source connection).
The \code{data.frame} should contain the following columns:
\itemize{
\item key_*: One (or more) columns containing keys to link this feature with other features
\item *: One (or more) columns containing the features that are computed
\item valid_from, valid_until: A set of columns containing the time period for which this feature information
is valid.\cr
}}

\item{\code{get}}{(\code{function})\cr
(Optional). A function of the form "function(target_table, slice_ts, target_conn)".
This function should retrieve the computed feature from the target connection.\cr}

\item{\code{key_join}}{(\code{function})\cr
A function like one of the aggregators from \code{\link[=aggregators]{aggregators()}}.

The function should return an expression on the form:
dplyr::summarise(.data,
dplyr::across(.cols = tidyselect::all_of(feature),
.fns = list(n = ~ aggregation function),
.names = "\{.fn\}"),
.groups = "drop")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new instance of the \code{FeatureHandler} \link[R6:R6Class]{R6} class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FeatureHandler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FeatureHandler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FeatureHandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
