% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dispRity.R
\name{plot.dispRity}
\alias{plot.dispRity}
\title{dispRity object plotting}
\usage{
\method{plot}{dispRity}(x, ..., type, quantiles = c(50, 95),
  cent.tend = median, rarefaction = NULL, elements = FALSE, ylim, xlab,
  ylab, col, chrono.subsets = TRUE, observed = FALSE, add = FALSE,
  density = NULL, element.pch = 15, nclass = 10, coeff = 1)
}
\arguments{
\item{x}{A \code{dispRity} object.}

\item{...}{Any optional arguments to be passed to \code{\link[graphics]{plot}}.}

\item{type}{Either \code{"continuous"} (\code{"c"}), \code{"box"} (\code{"b"}), \code{"line"} (\code{"l"}) or \code{"polygon"} (\code{"p"}). When unspecified, is set to \code{"continuous"} if \code{\link{chrono.subsets}} is used with \code{method = "continuous"}, else is set to \code{"box"}. See details.}

\item{quantiles}{The quantiles to display (default is \code{quantiles = c(50, 95)}; is ignored if the \code{dispRity} object is not bootstrapped).}

\item{cent.tend}{A function for summarising the bootstrapped disparity values (default is \code{\link[stats]{median}}).}

\item{rarefaction}{Either \code{NULL} (default) or \code{FALSE} for not using the rarefaction scores; a \code{numeric} value of the level of rarefaction to plot; or \code{TRUE} for plotting the rarefaction curves.}

\item{elements}{\code{logical} whether to plot the number of elements per subsets.}

\item{ylim}{Optional, two \code{numeric} values for the range of the y axis.}

\item{xlab}{Optional, a \code{character} string for the caption of the x axis.}

\item{ylab}{Optional, one or two (if \code{elements = TRUE}) \code{character} string(s) for the caption of the y axis.}

\item{col}{Optional, some \code{character} string(s) for the colour of the graph.}

\item{chrono.subsets}{\code{logical} whether to handle continuous data from the \code{chrono.subsets} function as time (in Ma). When this option is set to TRUE for other \code{type} options, the names of the subsets are used for the x axis labels.}

\item{observed}{\code{logical} whether to add the observed values on the plot as crosses (default is \code{FALSE}) or a \code{list} of any of the graphical arguments \code{"col"}, \code{"pch"} and/or \code{"cex"}.}

\item{add}{\code{logical} whether to add the new plot an existing one (default is \code{FALSE}).}

\item{density}{the density of shading lines to be passed to \code{\link[graphics]{polygon}}. Is ignored if \code{type = "box"} or \code{type = "line"}.}

\item{element.pch}{optional, if \code{elements = TRUE}, the point type to represent them (default are squares: \code{element.pch = 15})}

\item{nclass}{when plotting a \code{\link{null.test}} the number of \code{nclass} argument to be passed to \code{\link[graphics]{hist}} (default = \code{10}).}

\item{coeff}{when plotting a \code{\link{null.test}} the coefficient for the magnitude of the graph (see \code{\link[ade4]{randtest}}; default = \code{1}).}
}
\description{
Plots a \code{dispRity} object.
}
\details{
The different \code{type} arguments are:
\itemize{
  \item \code{"continuous"}: plots the results as a continuous line.
  \item \code{"box"}: plots the results as discrete box plots (note that this option ignores the user set quantiles and central tendency).
  \item \code{"line"}: plots the results as discrete vertical lines with the user's set quantiles and central tendency.
  \item \code{"polygon"}: identical as \code{"line"} but using polygons rather than vertical lines.
}
}
\examples{
## Load the disparity data based on Beck & Lee 2014
data(disparity)

## Discrete plotting
plot(disparity, type = "box")

## Using polygons rather than boxes (quantiles and central tendency can be
## set by the user)
plot(disparity, type = "polygon", quantiles = c(10, 50, 95),
     cent.tend = mean)

## Using different options
plot(disparity, type = "line", elements = TRUE, ylim = c(0, 5),
     xlab = ("Time (Ma)"), ylab = "disparity")

## Continuous plotting (all default options)
plot(disparity, type = "continuous")

## Using different options (with non time.slicing option)
plot(disparity, type = "continuous", chrono.subsets = FALSE,
     elements = TRUE, col = c("red", "orange", "yellow"))

## Rarefactions plots
plot(disparity, rarefaction = TRUE)

## Observed data
plot(disparity, observed = TRUE)

## Observed data with graphical details
plot(disparity, observed = list("pch" = 19, col = "blue", cex = 4))

\dontrun{
## Geoscale plots
require(geoscale)

## Converting the data into a list
data_obs <- extract.dispRity(disparity, observed = TRUE)
data_distribution <- extract.dispRity(disparity, observed = FALSE)
## Removing one list level
data_distribution <- unlist(data_distribution, recursive = FALSE)
data_obs <- as.vector(data_obs)

## Getting the ages
ages <- as.numeric(names(disparity$subsets))

## Plotting the results median
geoscalePlot(ages, data_obs, boxes = "Age", data.lim = c(1.5, 2), type = "l")

## Plotting the results distribution
geoscaleBox(data_distribution, ages, boxes = "Age", data.lim = c(1.5, 2))
}


}
\seealso{
\code{\link{dispRity}}, \code{\link{summary.dispRity}}, \code{\link{pair.plot}}.
}
\author{
Thomas Guillerme
}
