% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.matrix.R
\name{reduce.matrix}
\alias{reduce.matrix}
\title{Reduce a matrix}
\usage{
reduce.matrix(matrix, distance = "gower", by.row = TRUE,
  verbose = FALSE)
}
\arguments{
\item{matrix}{A matrix}

\item{distance}{which distance to consider (passed to \code{\link[vegan]{vegdist}}, default = \code{"gower"})}

\item{by.row}{Whether to do it by rows (\code{TRUE} - default), or by columns (\code{FALSE})}

\item{verbose}{Whether to do be verbose (\code{TRUE}) or not (\code{FALSE} - default)}
}
\description{
Reduce the number of rows/columns in a matrix to optimise overlap
}
\examples{
set.seed(1)
## A 10*5 matrix
na_matrix <- matrix(rnorm(50), 10, 5)
## Making sure some rows don't overlap
na_matrix[1, 1:2] <- NA
na_matrix[2, 3:5] <- NA
## Adding 50\% NAs
na_matrix[sample(1:50, 25)] <- NA
## Illustrating the gappy matrix
image(t(na_matrix), col = "black")

## Reducing the matrix by row
(reduction <- reduce.matrix(na_matrix))
## Illustrating the overlapping matrix
image(t(na_matrix[-as.numeric(reduction$rows.to.remove), ]), col = "black")

## Reducing the matrix by columns (and being verbose)
reduce.matrix(na_matrix, by.row = FALSE, verbose = TRUE)

}
\author{
Thomas Guillerme
}
