% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.axes.R
\name{select.axes}
\alias{select.axes}
\title{Selects ordination axes}
\usage{
select.axes(data, group, threshold = 0.95, inc.threshold = TRUE)
}
\arguments{
\item{data}{The trait space to analyse. This can be either a \code{"matrix"}, \code{"prcomp"}, \code{"princomp"} or a \code{"dispRity"} object.}

\item{group}{Optional, either a \code{list} of row numbers or names to be used as different groups or a \code{data.frame} with the same \eqn{k} elements as in \code{data} as rownames. If \code{data} is a \code{"dispRity"} object that already contains groups, the \code{group} argument is recycled.}

\item{threshold}{The arbitrary threshold amount of variance (by default this is \code{0.95}).}

\item{inc.threshold}{Logical, whether to output the axes that contain the threshold value (\code{TRUE}; default) or not (\code{FALSE}). See details.

, i.e. the axes necessary to include at least the threshold value}
}
\value{
A \code{"dispRity"}, \code{"axes"} object that can be printed, summarised and plot through generic \code{print}, \code{summary} and \code{plot} functions.
The object is a list containing:
\itemize{
     \item \code{$dimensions}: the maximum number of dimensions selected across all groups;
     \item \code{$dim.list}: the selected dimensions per group;
     \item \code{$var}: the variance per axes per group;
     \item \code{$scaled.var}: the variance scaled variance per axes per group;
     \item \code{$cumsum.var}: the cumulative scaled variance per axes per group;
     \item \code{$call}: a list containing the \code{$threshold} value and the \code{$inc.threshold} option used.
}
}
\description{
Selects the axes required to explain a cumulative threshold amount of variance in an ordination (e.g. > 95\%).
}
\details{
If \code{inc.threshold = TRUE}, the returned axes are the ones that contains at least the threshold value (e.g. if the threshold is \code{0.95}, all the returned axes contain at least \code{0.95} of the variance, potentially more). If \code{inc.threshold = FALSE}, the returned axes are the ones before reaching this threshold (e.g. the cumulative variance returned is strictly less or equal to \code{0.95}).
}
\examples{
## Ordinating the USArrests dataset
ordination <- princomp(USArrests, cor = TRUE)
## Which dimensions to select?
(selected <- select.axes(ordination))
## The selected dimensions
selected$dimensions
## Visualising the results
plot(selected)

## Same but by grouping the data into three groups
states_groups <- list("Group1" = c("Mississippi","North Carolina",
                                   "South Carolina", "Georgia", "Alabama",
                                   "Alaska", "Tennessee", "Louisiana"),
                      "Group2" = c("Florida", "New Mexico", "Michigan",
                                   "Indiana", "Virginia", "Wyoming", "Montana",
                                   "Maine", "Idaho", "New Hampshire", "Iowa"),
                      "Group3" = c("Rhode Island", "New Jersey", "Hawaii",
                                   "Massachusetts"))
(selected <- select.axes(ordination, group = states_groups))
## Note that the required number of axes is now 4 (instead of 3)
plot(selected)

## Loading some example dispRity data
data(demo_data)
## How many axes are required to explain 99\% of the variance
## for each group in the Healy et al 2019 data?
(how_many <- select.axes(demo_data$healy, threshold = 0.99))
summary(how_many)
plot(how_many)


}
\seealso{
\code{\link{custom.subsets}}
}
\author{
Thomas Guillerme
}
