% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psi_auto_sum.R
\name{psi_auto_sum}
\alias{psi_auto_sum}
\title{Auto Sum}
\usage{
psi_auto_sum(x = NULL, y = NULL, distance = "euclidean")
}
\arguments{
\item{x}{(required, zoo object or numeric matrix) univariate or multivariate time series with no NAs. Default: NULL.}

\item{y}{(required, zoo object or numeric matrix) a time series with the same number of columns as \code{x} and no NAs. Default: NULL.}

\item{distance}{(optional, character vector) name or abbreviation of the distance method. Valid values are in the columns "names" and "abbreviation" of the dataset \link{distances}. Default: "euclidean".}
}
\value{
numeric vector
}
\description{
Demonstration function to computes the sum of distances between consecutive samples in two time series.
}
\examples{
#distance metric
d <- "euclidean"

#simulate two irregular time series
x <- zoo_simulate(
  name = "x",
  rows = 100,
  seasons = 2,
  seed = 1
)

y <- zoo_simulate(
  name = "y",
  rows = 80,
  seasons = 2,
  seed = 2
)

if(interactive()){
  zoo_plot(x = x)
  zoo_plot(x = y)
}

#auto sum of distances
psi_auto_sum(
  x = x,
  y = y,
  distance = d
)

#same as:
x_sum <- psi_auto_distance(
  x = x,
  distance = d
)

y_sum <- psi_auto_distance(
  x = y,
  distance = d
)

x_sum + y_sum

}
\seealso{
Other psi_demo: 
\code{\link{psi_auto_distance}()},
\code{\link{psi_cost_matrix}()},
\code{\link{psi_cost_path}()},
\code{\link{psi_cost_path_sum}()},
\code{\link{psi_distance_lock_step}()},
\code{\link{psi_distance_matrix}()},
\code{\link{psi_equation}()}
}
\concept{psi_demo}
