% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionDecorator_ExoticStatistics.R
\name{survivalAntiDeriv}
\alias{survivalAntiDeriv}
\title{Survival Function Anti-Derivative}
\usage{
survivalAntiDeriv(object, lower = NULL, upper = NULL)
}
\arguments{
\item{object}{Distribution.}

\item{lower}{lower limit for integration, default is infimum.}

\item{upper}{upper limit for integration, default is supremum.}
}
\value{
Antiderivative of the survival function evaluated between limits as a numeric.
}
\description{
The anti-derivative of the survival function between given limits or
over the full support.
}
\details{
The survival anti-derivative is defined by
\deqn{as(a, b) = \int_a^b S_X(x) dx}
where X is the distribution, \eqn{S_X} is the survival function of the distribution \eqn{X} and \eqn{a, b} are the
limits of integration.

Can only be used after decorating with \code{\link{ExoticStatistics}}.
}
\section{R6 Usage}{
 $survivalAntiDeriv(lower = NULL, upper = NULL)
}

\seealso{
\code{\link{ExoticStatistics}} and \code{\link{decorate}}
}
