% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distribution.R
\name{correlation}
\alias{correlation}
\title{Distribution Correlation}
\usage{
correlation(object)
}
\arguments{
\item{object}{Distribution.}
}
\value{
Either '1' if distribution is univariate or the correlation as a numeric or matrix.
}
\description{
Correlation of a distribution.
}
\details{
In terms of covariance, the correlation of a distribution is defined by the equation,
\deqn{\rho_{XY} = \sigma_{XY}/\sigma_X\sigma_Y}
where \eqn{\sigma_{XY}} is the covariance of X and Y and \eqn{\sigma_X, \sigma_Y} and the respective
standard deviations of X and Y.

If the distribution is univariate then returns \eqn{1}.

Calculates correlation analytically from variance. If an analytic expression for variance isn't available,
returns error. To impute a numeric expression, use the \code{\link{CoreStatistics}} decorator.
}
\section{R6 Usage}{
 $correlation()
}

