% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testParameterSetCollectionList}
\alias{testParameterSetCollectionList}
\alias{checkParameterSetCollectionList}
\alias{assertParameterSetCollectionList}
\title{assert/check/test/ParameterSetCollectionList}
\usage{
testParameterSetCollectionList(
  object,
  errormsg = "One or more items in the list are not ParameterSetCollections"
)

checkParameterSetCollectionList(
  object,
  errormsg = "One or more items in the list are not ParameterSetCollections"
)

assertParameterSetCollectionList(
  object,
  errormsg = "One or more items in the list are not ParameterSetCollections"
)
}
\arguments{
\item{object}{object to test}

\item{errormsg}{custom error message to return if assert/check fails}
}
\value{
If check passes then \code{assert} returns invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is a list of \link{ParameterSetCollection}s.
}
\examples{
testParameterSetCollectionList(list(Binomial$new(), 5)) # FALSE
testParameterSetCollectionList(list(ParameterSetCollection$new(
  Binom = Binomial$new()$parameters()
))) # TRUE
}
