% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fam_data.R
\name{model_fam_data}
\alias{model_fam_data}
\title{Create a dataset to fit models with all possible families in bamlss}
\usage{
model_fam_data(nrow = 500, seed = 1408, fam_name = "NO")
}
\arguments{
\item{nrow}{Number of observations of the exported dataset.}

\item{seed}{The seed which should be used, for reproducibility.}

\item{fam_name}{The name of the distribution family to which the first
dimension of the uniform distribution should be transformed to.}
}
\value{
A data.frame with columns for differently distributed data.
}
\description{
Create a dataset to fit models with all possible families in bamlss
}
\details{
This function creates a 3-dimensional uniform distribution (with
  support from 0 to 1) which has a cross-correlation of 0.5. Then the first
  dimension is transformed into a specified distribution (argument
  \code{fam_name}) via Inverse Transform Sampling
  \url{https://en.wikipedia.org/wiki/Inverse_transform_sampling}. The other
  two dimensions are transformed into a normal distribution (norm2) and
  a binomial distribution (binomial1, for testing categorical explanatory
  covariates). This procedure ensures that there is a dependency structure of
  the transformed first distribution and the other two.
}
