% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poisson.R
\name{quantile.Poisson}
\alias{quantile.Poisson}
\title{Determine quantiles of a Poisson distribution}
\usage{
\method{quantile}{Poisson}(d, p, ...)
}
\arguments{
\item{d}{A \code{Poisson} object created by a call to \code{\link[=Poisson]{Poisson()}}.}

\item{p}{A vector of probabilites.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{p}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- Poisson(2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))

}
